/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;

public class RatioViewWrapper
extends ViewGroup {
    public static final float UNDEFINED_ASPECT_RATIO = -1.0f;
    private static final float EPSILON = 1.0E-11f;
    private float mAspectRatio = -1.0f;

    public RatioViewWrapper(@NonNull Context context) {
        this(context, null);
    }

    public RatioViewWrapper(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RatioViewWrapper(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int defStyleAttr) {
        this(context, attributeSet, defStyleAttr, 0);
    }

    public RatioViewWrapper(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
        this.requestLayout();
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() != 1) {
            throw new IllegalStateException("RatioViewWrapper must contain a single child");
        }
        int widthMeasureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMeasureMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        View childView = this.getChildAt(0);
        childView.measure(widthMeasureSpec, heightMeasureSpec);
        if (this.mAspectRatio == -1.0f) {
            this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
            RatioViewWrapper.combineMeasuredStates((int)this.getMeasuredState(), (int)childView.getMeasuredState());
            return;
        }
        if (widthMeasureMode == 0x40000000 && heightMeasureMode == 0x40000000) {
            this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
            return;
        }
        if (Math.abs((float)childView.getMeasuredWidth() / (float)childView.getMeasuredHeight() - this.mAspectRatio) <= 1.0E-11f) {
            this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
            return;
        }
        if (!(widthMeasureMode != Integer.MIN_VALUE && widthMeasureMode != 0 || heightMeasureMode != Integer.MIN_VALUE && heightMeasureMode != 0)) {
            float targetWidth = (float)childView.getMeasuredHeight() * this.mAspectRatio;
            float targetHeight = (float)childView.getMeasuredWidth() / this.mAspectRatio;
            if (targetWidth < (float)childView.getMeasuredWidth()) {
                int childWidth = View.MeasureSpec.makeMeasureSpec((int)((int)targetWidth), (int)0x40000000);
                int childHeight = View.MeasureSpec.makeMeasureSpec((int)childView.getMeasuredHeight(), (int)0x40000000);
                childView.measure(childWidth, childHeight);
                this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
                return;
            } else {
                if (!(targetHeight < (float)childView.getMeasuredHeight())) throw new IllegalStateException("Neither target width nor target height was smaller than measured width/height");
                int childWidth = View.MeasureSpec.makeMeasureSpec((int)childView.getMeasuredWidth(), (int)0x40000000);
                int childHeight = View.MeasureSpec.makeMeasureSpec((int)((int)targetHeight), (int)0x40000000);
                childView.measure(childWidth, childHeight);
                this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
            }
            return;
        } else if (widthMeasureMode == 0x40000000) {
            float targetHeight = (float)childView.getMeasuredWidth() / this.mAspectRatio;
            int childWidth = View.MeasureSpec.makeMeasureSpec((int)childView.getMeasuredWidth(), (int)0x40000000);
            int childHeight = View.MeasureSpec.makeMeasureSpec((int)((int)targetHeight), (int)0x40000000);
            childView.measure(childWidth, childHeight);
            this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
            return;
        } else {
            if (heightMeasureMode != 0x40000000) throw new IllegalArgumentException("Unknown measure mode bits in given MeasureSpecs");
            float targetWidth = (float)childView.getMeasuredHeight() * this.mAspectRatio;
            int childWidth = View.MeasureSpec.makeMeasureSpec((int)((int)targetWidth), (int)0x40000000);
            int childHeight = View.MeasureSpec.makeMeasureSpec((int)childView.getMeasuredHeight(), (int)0x40000000);
            childView.measure(childWidth, childHeight);
            this.setMeasuredDimension(childView.getMeasuredWidth(), childView.getMeasuredHeight());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View childView = this.getChildAt(0);
        childView.layout(0, 0, childView.getMeasuredWidth(), childView.getMeasuredHeight());
    }

    public void setPadding(int left, int top, int right, int bottom) {
        View childView = this.getChildAt(0);
        childView.setPadding(left, top, right, bottom);
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        View childView = this.getChildAt(0);
        childView.setPaddingRelative(start, top, end, bottom);
    }
}

