/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.wear.protolayout.proto.FingerprintProto;
import androidx.wear.protolayout.renderer.common.ProtoLayoutDiffer;
import java.util.ArrayList;
import java.util.Map;

public final class RenderedMetadata {
    @NonNull
    private final FingerprintProto.TreeFingerprint mTreeFingerprint;
    @NonNull
    private final LayoutInfo mLayoutInfo;

    RenderedMetadata(@NonNull FingerprintProto.TreeFingerprint treeFingerprint, @NonNull LayoutInfo layoutInfo) {
        this.mTreeFingerprint = treeFingerprint;
        this.mLayoutInfo = layoutInfo;
    }

    @NonNull
    FingerprintProto.TreeFingerprint getTreeFingerprint() {
        return this.mTreeFingerprint;
    }

    @NonNull
    LayoutInfo getLayoutInfo() {
        return this.mLayoutInfo;
    }

    static final class LayoutInfo {
        @NonNull
        final Map<String, ViewProperties> mPositionIdToLayoutInfo;

        LayoutInfo(@NonNull Map<String, ViewProperties> positionIdToLayoutInfo) {
            this.mPositionIdToLayoutInfo = positionIdToLayoutInfo;
        }

        boolean contains(@NonNull String positionId) {
            return this.mPositionIdToLayoutInfo.containsKey(positionId);
        }

        @Nullable
        ViewProperties getViewPropertiesFor(@NonNull String positionId) {
            return this.mPositionIdToLayoutInfo.get(positionId);
        }

        static final class Builder {
            @NonNull
            private final Map<String, ViewProperties> mPositionIdToViewProperties = new ArrayMap();
            @NonNull
            private final ArrayList<String> mSubtreePosIdPendingRemoval = new ArrayList();
            @Nullable
            private final LayoutInfo mPreviousLayoutInfo;

            Builder(@Nullable LayoutInfo previousLayoutInfo) {
                this.mPreviousLayoutInfo = previousLayoutInfo;
            }

            void add(@NonNull String positionId, @NonNull ViewProperties viewProperties) {
                this.mPositionIdToViewProperties.put(positionId, viewProperties);
            }

            @Nullable
            ViewProperties getViewPropertiesFor(@NonNull String posId) {
                return this.mPositionIdToViewProperties.get(posId);
            }

            void removeSubtree(@NonNull String positionId) {
                this.mSubtreePosIdPendingRemoval.add(positionId);
            }

            LayoutInfo build() {
                LayoutInfo layoutInfo = new LayoutInfo(this.mPreviousLayoutInfo != null ? this.mPreviousLayoutInfo.mPositionIdToLayoutInfo : new ArrayMap());
                for (String subtreePosId : this.mSubtreePosIdPendingRemoval) {
                    layoutInfo.mPositionIdToLayoutInfo.keySet().removeIf(s -> ProtoLayoutDiffer.isDescendantOf(s, subtreePosId));
                }
                layoutInfo.mPositionIdToLayoutInfo.putAll(this.mPositionIdToViewProperties);
                return layoutInfo;
            }
        }
    }

    static final class FrameLayoutProperties
    extends ViewProperties {
        @NonNull
        private final PendingLayoutParams mChildLayoutParams;

        FrameLayoutProperties(@NonNull PendingLayoutParams childLayoutParams) {
            this.mChildLayoutParams = childLayoutParams;
        }

        @Override
        @NonNull
        ViewGroup.LayoutParams applyPendingChildLayoutParams(@NonNull ViewGroup.LayoutParams layoutParams) {
            return this.mChildLayoutParams.apply(layoutParams);
        }
    }

    static final class LinearLayoutProperties
    extends ViewProperties {
        private final int mOrientation;
        @NonNull
        private final ViewGroup.LayoutParams mRawLayoutParams;

        LinearLayoutProperties(int orientation, @NonNull ViewGroup.LayoutParams rawLayoutParams) {
            this.mOrientation = orientation;
            this.mRawLayoutParams = rawLayoutParams;
        }

        int getOrientation() {
            return this.mOrientation;
        }

        @NonNull
        ViewGroup.LayoutParams getRawLayoutParams() {
            return this.mRawLayoutParams;
        }
    }

    static class ViewProperties {
        @NonNull
        static final ViewProperties EMPTY = new ViewProperties();

        ViewProperties() {
        }

        @NonNull
        static ViewProperties fromViewGroup(@NonNull ViewGroup viewGroup, @NonNull ViewGroup.LayoutParams rawLayoutParams, @NonNull PendingLayoutParams childLayoutParams) {
            if (viewGroup instanceof LinearLayout) {
                return new LinearLayoutProperties(((LinearLayout)viewGroup).getOrientation(), rawLayoutParams);
            }
            if (viewGroup instanceof FrameLayout) {
                return new FrameLayoutProperties(childLayoutParams);
            }
            return EMPTY;
        }

        @NonNull
        ViewGroup.LayoutParams applyPendingChildLayoutParams(@NonNull ViewGroup.LayoutParams layoutParams) {
            return layoutParams;
        }
    }

    static final class PendingFrameLayoutParams
    implements PendingLayoutParams {
        private final int mGravity;

        PendingFrameLayoutParams(int gravity) {
            this.mGravity = gravity;
        }

        @Override
        @NonNull
        public ViewGroup.LayoutParams apply(@NonNull ViewGroup.LayoutParams layoutParams) {
            FrameLayout.LayoutParams frameLayoutParams = layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : (layoutParams instanceof ViewGroup.MarginLayoutParams ? new FrameLayout.LayoutParams((ViewGroup.MarginLayoutParams)layoutParams) : new FrameLayout.LayoutParams(layoutParams));
            frameLayoutParams.gravity = this.mGravity;
            return frameLayoutParams;
        }
    }

    static interface PendingLayoutParams {
        @NonNull
        public ViewGroup.LayoutParams apply(@NonNull ViewGroup.LayoutParams var1);
    }
}

