/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.proto.TriggerProto;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public class ResourceResolvers {
    @NonNull
    private final ResourceProto.Resources mProtoResources;
    @Nullable
    private final AndroidImageResourceByResIdResolver mAndroidImageResourceByResIdResolver;
    @Nullable
    private final AndroidAnimatedImageResourceByResIdResolver mAndroidAnimatedImageResourceByResIdResolver;
    @Nullable
    private final AndroidSeekableAnimatedImageResourceByResIdResolver mAndroidSeekableAnimatedImageResourceByResIdResolver;
    @Nullable
    private final InlineImageResourceResolver mInlineImageResourceResolver;
    @Nullable
    private final AndroidImageResourceByContentUriResolver mAndroidImageResourceByContentUriResolver;

    ResourceResolvers(@NonNull ResourceProto.Resources protoResources, @Nullable AndroidImageResourceByResIdResolver androidImageResourceByResIdResolver, @Nullable AndroidAnimatedImageResourceByResIdResolver androidAnimatedImageResourceByResIdResolver, @Nullable AndroidSeekableAnimatedImageResourceByResIdResolver androidSeekableAnimatedImageResourceByResIdResolver, @Nullable InlineImageResourceResolver inlineImageResourceResolver, @Nullable AndroidImageResourceByContentUriResolver androidContentUriResolver) {
        this.mProtoResources = protoResources;
        this.mAndroidImageResourceByResIdResolver = androidImageResourceByResIdResolver;
        this.mAndroidAnimatedImageResourceByResIdResolver = androidAnimatedImageResourceByResIdResolver;
        this.mAndroidSeekableAnimatedImageResourceByResIdResolver = androidSeekableAnimatedImageResourceByResIdResolver;
        this.mInlineImageResourceResolver = inlineImageResourceResolver;
        this.mAndroidImageResourceByContentUriResolver = androidContentUriResolver;
    }

    @NonNull
    public static Builder builder(@NonNull ResourceProto.Resources protoResources) {
        return new Builder(protoResources);
    }

    public boolean hasPlaceholderDrawable(@NonNull String protoResourceId) {
        return this.getPlaceholderResourceId(protoResourceId) != null;
    }

    @NonNull
    public Drawable getPlaceholderDrawableOrThrow(@NonNull String protoResourceId) throws ResourceAccessException {
        String placeholderResourceId = this.getPlaceholderResourceId(protoResourceId);
        if (placeholderResourceId == null) {
            throw new ResourceAccessException("Resource " + protoResourceId + " does not have a placeholder resource.");
        }
        ResourceProto.ImageResource placeholderImageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(placeholderResourceId);
        if (placeholderImageResource == null) {
            throw new IllegalArgumentException("Resource " + placeholderResourceId + " is not defined in resources bundle");
        }
        Drawable placeHolderDrawable = this.getDrawableForImageResourceSynchronously(placeholderImageResource);
        if (placeHolderDrawable != null) {
            return placeHolderDrawable;
        }
        if (placeholderImageResource.hasAndroidContentUri()) {
            throw new ResourceAccessException("Content URI images cannot be used as placeholders");
        }
        throw new ResourceAccessException("Can't find resolver for image resource.");
    }

    @NonNull
    public ListenableFuture<Drawable> getDrawable(@NonNull String protoResourceId) {
        ResourceProto.ImageResource imageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(protoResourceId);
        if (imageResource == null) {
            return Futures.immediateFailedFuture((Throwable)new IllegalArgumentException("Resource " + protoResourceId + " is not defined in resources bundle"));
        }
        ListenableFuture<Drawable> drawableFutureOrNull = this.getDrawableForImageResource(imageResource);
        if (drawableFutureOrNull == null) {
            return Futures.immediateFailedFuture((Throwable)new ResourceAccessException("Can't find resolver for image resource " + protoResourceId));
        }
        return drawableFutureOrNull;
    }

    @Nullable
    public TriggerProto.Trigger getAnimationTrigger(@NonNull String protoResourceId) {
        ResourceProto.ImageResource imageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(protoResourceId);
        if (imageResource != null && imageResource.hasAndroidAnimatedResourceByResId()) {
            return imageResource.getAndroidAnimatedResourceByResId().getStartTrigger();
        }
        throw new IllegalArgumentException("Resource " + protoResourceId + " is not an animated resource, thus no animation trigger");
    }

    @Nullable
    public DynamicProto.DynamicFloat getBoundProgress(@NonNull String protoResourceId) {
        ResourceProto.ImageResource imageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(protoResourceId);
        if (imageResource != null && imageResource.hasAndroidSeekableAnimatedResourceByResId()) {
            return imageResource.getAndroidSeekableAnimatedResourceByResId().getProgress();
        }
        throw new IllegalArgumentException("Resource " + protoResourceId + " is not a seekable animated resource, thus no bound progress to a DynamicFloat");
    }

    @Nullable
    Drawable getDrawableForImageResourceSynchronously(@NonNull ResourceProto.ImageResource imageResource) throws ResourceAccessException {
        if (imageResource.hasAndroidAnimatedResourceByResId() && this.mAndroidAnimatedImageResourceByResIdResolver != null) {
            AndroidAnimatedImageResourceByResIdResolver resolver = this.mAndroidAnimatedImageResourceByResIdResolver;
            return resolver.getDrawableOrThrow(imageResource.getAndroidAnimatedResourceByResId());
        }
        if (imageResource.hasAndroidSeekableAnimatedResourceByResId() && this.mAndroidSeekableAnimatedImageResourceByResIdResolver != null) {
            AndroidSeekableAnimatedImageResourceByResIdResolver resolver = this.mAndroidSeekableAnimatedImageResourceByResIdResolver;
            return resolver.getDrawableOrThrow(imageResource.getAndroidSeekableAnimatedResourceByResId());
        }
        if (imageResource.hasAndroidResourceByResId() && this.mAndroidImageResourceByResIdResolver != null) {
            AndroidImageResourceByResIdResolver resolver = this.mAndroidImageResourceByResIdResolver;
            return resolver.getDrawableOrThrow(imageResource.getAndroidResourceByResId());
        }
        if (imageResource.hasInlineResource() && this.mInlineImageResourceResolver != null) {
            InlineImageResourceResolver resolver = this.mInlineImageResourceResolver;
            return resolver.getDrawableOrThrow(imageResource.getInlineResource());
        }
        return null;
    }

    @Nullable
    protected ListenableFuture<Drawable> getDrawableForImageResource(@NonNull ResourceProto.ImageResource imageResource) {
        try {
            Drawable drawable = this.getDrawableForImageResourceSynchronously(imageResource);
            if (drawable != null) {
                return Futures.immediateFuture((Object)drawable);
            }
        }
        catch (ResourceAccessException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        if (imageResource.hasAndroidContentUri() && this.mAndroidImageResourceByContentUriResolver != null) {
            AndroidImageResourceByContentUriResolver resolver = this.mAndroidImageResourceByContentUriResolver;
            return resolver.getDrawable(imageResource.getAndroidContentUri());
        }
        return null;
    }

    public boolean canImageBeTinted(@NonNull String protoResourceId) {
        ResourceProto.ImageResource imageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(protoResourceId);
        if (imageResource == null) {
            throw new IllegalArgumentException("Resource " + protoResourceId + " is not defined in resources bundle");
        }
        return imageResource.hasAndroidResourceByResId() || imageResource.hasAndroidAnimatedResourceByResId() || imageResource.hasAndroidSeekableAnimatedResourceByResId();
    }

    @Nullable
    protected String getPlaceholderResourceId(@NonNull String originalResourceId) {
        ResourceProto.ImageResource imageResource = (ResourceProto.ImageResource)this.mProtoResources.getIdToImageMap().get(originalResourceId);
        if (imageResource == null) {
            throw new IllegalArgumentException("Resource " + originalResourceId + " is not defined in resources bundle");
        }
        return null;
    }

    public static interface AndroidImageResourceByResIdResolver {
        @NonNull
        public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidImageResourceByResId var1) throws ResourceAccessException;
    }

    public static interface AndroidAnimatedImageResourceByResIdResolver {
        @NonNull
        public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidAnimatedImageResourceByResId var1) throws ResourceAccessException;
    }

    public static interface AndroidSeekableAnimatedImageResourceByResIdResolver {
        @NonNull
        public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidSeekableAnimatedImageResourceByResId var1) throws ResourceAccessException;
    }

    public static interface InlineImageResourceResolver {
        @NonNull
        public Drawable getDrawableOrThrow(@NonNull ResourceProto.InlineImageResource var1) throws ResourceAccessException;
    }

    public static interface AndroidImageResourceByContentUriResolver {
        @NonNull
        public ListenableFuture<Drawable> getDrawable(@NonNull ResourceProto.AndroidImageResourceByContentUri var1);
    }

    public static final class Builder {
        @NonNull
        private final ResourceProto.Resources mProtoResources;
        @Nullable
        private AndroidImageResourceByResIdResolver mAndroidImageResourceByResIdResolver;
        @Nullable
        private AndroidAnimatedImageResourceByResIdResolver mAndroidAnimatedImageResourceByResIdResolver;
        @Nullable
        private AndroidSeekableAnimatedImageResourceByResIdResolver mAndroidSeekableAnimatedImageResourceByResIdResolver;
        @Nullable
        private InlineImageResourceResolver mInlineImageResourceResolver;
        @Nullable
        private AndroidImageResourceByContentUriResolver mAndroidImageResourceByContentUriResolver;

        Builder(@NonNull ResourceProto.Resources protoResources) {
            this.mProtoResources = protoResources;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAndroidImageResourceByResIdResolver(@NonNull AndroidImageResourceByResIdResolver resolver) {
            this.mAndroidImageResourceByResIdResolver = resolver;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAndroidAnimatedImageResourceByResIdResolver(@NonNull AndroidAnimatedImageResourceByResIdResolver resolver) {
            this.mAndroidAnimatedImageResourceByResIdResolver = resolver;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAndroidSeekableAnimatedImageResourceByResIdResolver(@NonNull AndroidSeekableAnimatedImageResourceByResIdResolver resolver) {
            this.mAndroidSeekableAnimatedImageResourceByResIdResolver = resolver;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setInlineImageResourceResolver(@NonNull InlineImageResourceResolver resolver) {
            this.mInlineImageResourceResolver = resolver;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAndroidImageResourceByContentUriResolver(@NonNull AndroidImageResourceByContentUriResolver resolver) {
            this.mAndroidImageResourceByContentUriResolver = resolver;
            return this;
        }

        @NonNull
        public ResourceResolvers build() {
            return new ResourceResolvers(this.mProtoResources, this.mAndroidImageResourceByResIdResolver, this.mAndroidAnimatedImageResourceByResIdResolver, this.mAndroidSeekableAnimatedImageResourceByResIdResolver, this.mInlineImageResourceResolver, this.mAndroidImageResourceByContentUriResolver);
        }
    }

    public static final class ResourceAccessException
    extends Exception {
        public ResourceAccessException(@NonNull String description) {
            super(description);
        }

        public ResourceAccessException(@NonNull String description, @NonNull Exception cause) {
            super(description, cause);
        }
    }
}

