/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.renderer.R;
import androidx.wear.widget.ArcLayout;

class SizedArcContainer
extends ViewGroup
implements ArcLayout.Widget {
    private static final float DEFAULT_SWEEP_ANGLE_DEGREES = 0.0f;
    private float mSweepAngleDegrees;

    SizedArcContainer(@NonNull Context context) {
        this(context, null);
    }

    SizedArcContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    SizedArcContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    SizedArcContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SizedArcContainer, defStyleAttr, defStyleRes);
        this.mSweepAngleDegrees = a.getFloat(R.styleable.SizedArcContainer_sweepAngleDegrees, 0.0f);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            child.measure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(SizedArcContainer.resolveSizeAndState((int)child.getMeasuredWidth(), (int)widthMeasureSpec, (int)child.getMeasuredState()), SizedArcContainer.resolveSizeAndState((int)child.getMeasuredHeight(), (int)heightMeasureSpec, (int)child.getMeasuredState()));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            child.layout(0, 0, r - l, b - t);
        }
    }

    public void addView(@NonNull View child, int index, @NonNull ViewGroup.LayoutParams layoutParams) {
        if (!(child instanceof ArcLayout.Widget)) {
            throw new IllegalArgumentException("SizedArcContainer can only contain instances of ArcLayout.Widget");
        }
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("SizedArcContainer can only have a single child");
        }
        super.addView(child, index, layoutParams);
    }

    protected boolean checkLayoutParams(@NonNull ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @NonNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NonNull ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public float getSweepAngleDegrees() {
        return this.mSweepAngleDegrees;
    }

    public void setSweepAngleDegrees(float sweepAngleDegrees) {
        this.mSweepAngleDegrees = sweepAngleDegrees;
        this.requestLayout();
    }

    public int getThickness() {
        ArcLayout.Widget child = this.getChild();
        if (child != null) {
            return child.getThickness();
        }
        return 0;
    }

    public void checkInvalidAttributeAsChild() {
        ArcLayout.Widget child = this.getChild();
        if (child != null) {
            child.checkInvalidAttributeAsChild();
        }
    }

    @Nullable
    private ArcLayout.Widget getChild() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return (ArcLayout.Widget)this.getChildAt(0);
    }

    public boolean isPointInsideClickArea(float x, float y) {
        return false;
    }

    protected boolean drawChild(@NonNull Canvas canvas, @NonNull View child, long drawingTime) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp == null) {
            return super.drawChild(canvas, child, drawingTime);
        }
        int alignment = lp.mAngularAlignment;
        int centerX = this.getMeasuredWidth() / 2;
        int centerY = this.getMeasuredHeight() / 2;
        float childSweep = ((ArcLayout.Widget)child).getSweepAngleDegrees();
        float offsetDegrees = (this.mSweepAngleDegrees - childSweep) / 2.0f;
        switch (alignment) {
            case 0: {
                canvas.rotate(-offsetDegrees, (float)centerX, (float)centerY);
                return super.drawChild(canvas, child, drawingTime);
            }
            case 2: {
                canvas.rotate(offsetDegrees, (float)centerX, (float)centerY);
                return super.drawChild(canvas, child, drawingTime);
            }
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int ANGULAR_ALIGNMENT_START = 0;
        public static final int ANGULAR_ALIGNMENT_CENTER = 1;
        public static final int ANGULAR_ALIGNMENT_END = 2;
        private static final int ANGULAR_ALIGNMENT_DEFAULT = 1;
        int mAngularAlignment;

        LayoutParams(@NonNull Context context, @NonNull AttributeSet attrs) {
            super(context, attrs);
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.SizedArcContainer_Layout);
            this.mAngularAlignment = arr.getInt(R.styleable.SizedArcContainer_Layout_angularAlignment, 1);
            arr.recycle();
        }

        LayoutParams(int width, int height) {
            super(width, height);
        }

        LayoutParams(@NonNull ViewGroup.LayoutParams source) {
            super(source);
        }

        void setAngularAlignment(int angularAlignment) {
            this.mAngularAlignment = angularAlignment;
        }
    }
}

