/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.graphics.Paint;
import android.text.style.LineHeightSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Px;

class StandardLineHeightSpan
implements LineHeightSpan {
    @Px
    private final int mLineHeightPx;

    StandardLineHeightSpan(int lineHeightPx) {
        this.mLineHeightPx = lineHeightPx;
    }

    public void chooseHeight(@NonNull CharSequence text, int start, int end, int spanstartv, int lineHeight, @NonNull Paint.FontMetricsInt fm) {
        int originHeight = fm.descent - fm.ascent;
        if (originHeight <= 0) {
            return;
        }
        float ratio = (float)this.mLineHeightPx * 1.0f / (float)originHeight;
        fm.descent = Math.round((float)fm.descent * ratio);
        fm.ascent = fm.descent - this.mLineHeightPx;
    }

    public int getLineHeight() {
        return this.mLineHeightPx;
    }
}

