/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.DefaultAndroidAnimatedImageResourceByResIdResolver;
import androidx.wear.protolayout.renderer.inflater.DefaultAndroidImageResourceByContentUriResolver;
import androidx.wear.protolayout.renderer.inflater.DefaultAndroidImageResourceByResIdResolver;
import androidx.wear.protolayout.renderer.inflater.DefaultAndroidSeekableAnimatedImageResourceByResIdResolver;
import androidx.wear.protolayout.renderer.inflater.DefaultInlineImageResourceResolver;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import java.util.concurrent.Executor;

public class StandardResourceResolvers {
    private StandardResourceResolvers() {
    }

    @SuppressLint(value={"CheckResult"})
    @NonNull
    public static ResourceResolvers.Builder forLocalApp(@NonNull ResourceProto.Resources protoResources, @NonNull Context appContext, @NonNull Executor asyncLoadExecutor, boolean animationEnabled) {
        DefaultAndroidImageResourceByResIdResolver androidResourceResolver = new DefaultAndroidImageResourceByResIdResolver(appContext.getResources());
        DefaultInlineImageResourceResolver inlineResourceResolver = new DefaultInlineImageResourceResolver(appContext);
        DefaultAndroidImageResourceByContentUriResolver contentUriResolver = null;
        if (asyncLoadExecutor != null) {
            contentUriResolver = new DefaultAndroidImageResourceByContentUriResolver(appContext, appContext.getPackageName(), appContext.getResources(), appContext.getContentResolver(), asyncLoadExecutor);
        }
        ResourceResolvers.Builder builder = ResourceResolvers.builder(protoResources).setAndroidImageResourceByResIdResolver(androidResourceResolver).setInlineImageResourceResolver(inlineResourceResolver);
        if (contentUriResolver != null) {
            builder.setAndroidImageResourceByContentUriResolver(contentUriResolver);
        }
        if (animationEnabled) {
            DefaultAndroidAnimatedImageResourceByResIdResolver androidAnimatedResourceResolver = new DefaultAndroidAnimatedImageResourceByResIdResolver(appContext.getResources());
            DefaultAndroidSeekableAnimatedImageResourceByResIdResolver androidSeekableAnimatedResourceResolver = new DefaultAndroidSeekableAnimatedImageResourceByResIdResolver(appContext.getResources());
            builder.setAndroidAnimatedImageResourceByResIdResolver(androidAnimatedResourceResolver).setAndroidSeekableAnimatedImageResourceByResIdResolver(androidSeekableAnimatedResourceResolver);
        }
        return builder;
    }

    @SuppressLint(value={"CheckResult"})
    @NonNull
    public static ResourceResolvers.Builder forRemoteService(@NonNull ResourceProto.Resources protoResources, @NonNull String servicePackageName, @NonNull Resources serviceAndroidResources, @NonNull Context hostAppContext, @NonNull Executor asyncLoadExecutor, boolean animationEnabled) {
        DefaultAndroidImageResourceByResIdResolver androidResourceResolver = new DefaultAndroidImageResourceByResIdResolver(serviceAndroidResources);
        DefaultInlineImageResourceResolver inlineResourceResolver = new DefaultInlineImageResourceResolver(hostAppContext);
        DefaultAndroidImageResourceByContentUriResolver contentUriResolver = null;
        if (asyncLoadExecutor != null) {
            contentUriResolver = new DefaultAndroidImageResourceByContentUriResolver(hostAppContext, servicePackageName, serviceAndroidResources, hostAppContext.getContentResolver(), asyncLoadExecutor);
        }
        ResourceResolvers.Builder builder = ResourceResolvers.builder(protoResources).setAndroidImageResourceByResIdResolver(androidResourceResolver).setInlineImageResourceResolver(inlineResourceResolver);
        if (contentUriResolver != null) {
            builder.setAndroidImageResourceByContentUriResolver(contentUriResolver);
        }
        if (animationEnabled) {
            DefaultAndroidAnimatedImageResourceByResIdResolver androidAnimatedResourceResolver = new DefaultAndroidAnimatedImageResourceByResIdResolver(serviceAndroidResources);
            DefaultAndroidSeekableAnimatedImageResourceByResIdResolver androidSeekableAnimatedResourceResolver = new DefaultAndroidSeekableAnimatedImageResourceByResIdResolver(serviceAndroidResources);
            builder.setAndroidAnimatedImageResourceByResIdResolver(androidAnimatedResourceResolver).setAndroidSeekableAnimatedImageResourceByResIdResolver(androidSeekableAnimatedResourceResolver);
        }
        return builder;
    }
}

