/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.renderer.R;
import androidx.wear.widget.ArcLayout;

public class WearCurvedLineView
extends View
implements ArcLayout.Widget {
    public static final float SWEEP_ANGLE_WRAP_LENGTH = -1.0f;
    private static final int DEFAULT_THICKNESS_PX = 0;
    private static final float DEFAULT_MAX_SWEEP_ANGLE_DEGREES = -1.0f;
    private static final float DEFAULT_LINE_SWEEP_ANGLE_DEGREES = 0.0f;
    private static final int DEFAULT_LINE_STROKE_CAP = Paint.Cap.ROUND.ordinal();
    @ColorInt
    private static final int DEFAULT_COLOR = -1;
    private int mThicknessPx;
    private float mMaxSweepAngleDegrees;
    private float mLineSweepAngleDegrees;
    @ColorInt
    private int mColor;
    @Nullable
    private Paint mPaint;
    @Nullable
    private Path mPath;
    @NonNull
    private Paint.Cap mCap;

    public WearCurvedLineView(@NonNull Context context) {
        this(context, null);
    }

    public WearCurvedLineView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearCurvedLineView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearCurvedLineView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WearCurvedLineView, defStyleAttr, defStyleRes);
        this.mThicknessPx = (int)a.getDimension(R.styleable.WearCurvedLineView_thickness, 0.0f);
        this.mColor = a.getColor(R.styleable.WearCurvedLineView_color, -1);
        this.mMaxSweepAngleDegrees = a.getFloat(R.styleable.WearCurvedLineView_maxSweepAngleDegrees, -1.0f);
        this.mLineSweepAngleDegrees = a.getFloat(R.styleable.WearCurvedLineView_sweepAngleDegrees, 0.0f);
        this.mCap = Paint.Cap.values()[a.getInt(R.styleable.WearCurvedLineView_strokeCap, DEFAULT_LINE_STROKE_CAP)];
        a.recycle();
    }

    private void updatePathAndPaint() {
        float insetPx = (float)this.mThicknessPx / 2.0f;
        float clampedLineLength = this.resolveSweepAngleDegrees();
        this.mPath = new Path();
        if (clampedLineLength >= 360.0f) {
            this.mPath.addOval(insetPx, insetPx, (float)this.getMeasuredWidth() - insetPx, (float)this.getMeasuredHeight() - insetPx, Path.Direction.CW);
        } else if (clampedLineLength != 0.0f) {
            this.mPath.moveTo(0.0f, 0.0f);
            this.mPath.arcTo(insetPx, insetPx, (float)this.getMeasuredWidth() - insetPx, (float)this.getMeasuredHeight() - insetPx, -90.0f - clampedLineLength / 2.0f, clampedLineLength, true);
        }
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(this.mCap);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeWidth((float)this.mThicknessPx);
        this.mPaint.setAntiAlias(true);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updatePathAndPaint();
    }

    public void setThickness(int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        this.mThicknessPx = thickness;
        this.updatePathAndPaint();
        this.requestLayout();
        this.postInvalidate();
    }

    private float resolveSweepAngleDegrees() {
        return this.mMaxSweepAngleDegrees == -1.0f ? this.mLineSweepAngleDegrees : Math.min(this.mLineSweepAngleDegrees, this.mMaxSweepAngleDegrees);
    }

    public float getSweepAngleDegrees() {
        return this.resolveSweepAngleDegrees();
    }

    public void setSweepAngleDegrees(float sweepAngleDegrees) {
        this.mLineSweepAngleDegrees = sweepAngleDegrees;
    }

    public float getLineSweepAngleDegrees() {
        return this.mLineSweepAngleDegrees;
    }

    public int getThickness() {
        return this.mThicknessPx;
    }

    public void setMaxSweepAngleDegrees(float maxSweepAngleDegrees) {
        this.mMaxSweepAngleDegrees = maxSweepAngleDegrees;
        this.updatePathAndPaint();
        this.requestLayout();
        this.postInvalidate();
    }

    public float getMaxSweepAngleDegrees() {
        return this.mMaxSweepAngleDegrees;
    }

    public void setLineSweepAngleDegrees(float lineLengthDegrees) {
        this.mLineSweepAngleDegrees = lineLengthDegrees;
        this.updatePathAndPaint();
        this.requestLayout();
        this.postInvalidate();
    }

    @ColorInt
    public int getColor() {
        return this.mColor;
    }

    public void setColor(@ColorInt int color) {
        this.mColor = color;
        this.updatePathAndPaint();
        this.invalidate();
    }

    @NonNull
    public Paint.Cap getStrokeCap() {
        return this.mCap;
    }

    public void setStrokeCap(@NonNull Paint.Cap cap) {
        this.mCap = cap;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.mPath == null || this.mPaint == null) {
            return;
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void checkInvalidAttributeAsChild() {
    }

    public boolean isPointInsideClickArea(float x, float y) {
        float dy;
        float radius2 = (float)Math.min(this.getWidth(), this.getHeight()) / 2.0f - (float)this.getPaddingTop();
        float radius1 = radius2 - (float)this.mThicknessPx;
        float dx = x - (float)this.getWidth() / 2.0f;
        float r2 = dx * dx + (dy = y - (float)this.getHeight() / 2.0f) * dy;
        if (r2 < radius1 * radius1 || r2 > radius2 * radius2) {
            return false;
        }
        float angle = (float)Math.toDegrees(Math.atan2(Math.abs(dx), -dy));
        return angle < this.resolveSweepAngleDegrees() / 2.0f;
    }
}

