/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.renderer.R;
import androidx.wear.widget.ArcLayout;

public class WearCurvedSpacer
extends View
implements ArcLayout.Widget {
    private static final float DEFAULT_SWEEP_ANGLE_DEGREES = 0.0f;
    private static final int DEFAULT_THICKNESS_PX = 0;
    private float mSweepAngleDegrees;
    private int mThicknessPx;

    public WearCurvedSpacer(@NonNull Context context) {
        this(context, null);
    }

    public WearCurvedSpacer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearCurvedSpacer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearCurvedSpacer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WearCurvedSpacer);
        this.mSweepAngleDegrees = a.getFloat(R.styleable.WearCurvedSpacer_sweepAngleDegrees, 0.0f);
        this.mThicknessPx = (int)a.getDimension(R.styleable.WearCurvedSpacer_thickness, 0.0f);
        a.recycle();
    }

    public float getSweepAngleDegrees() {
        return this.mSweepAngleDegrees;
    }

    public int getThickness() {
        return this.mThicknessPx;
    }

    public void setSweepAngleDegrees(float sweepAngleDegrees) {
        this.mSweepAngleDegrees = sweepAngleDegrees;
    }

    public void setThickness(int thickness) {
        this.mThicknessPx = thickness;
    }

    public void checkInvalidAttributeAsChild() {
    }

    public boolean isPointInsideClickArea(float x, float y) {
        return false;
    }
}

