/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.work.Logger;
import androidx.work.impl.background.gcm.WorkManagerGcmDispatcher;
import androidx.work.impl.utils.WorkTimer;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;

public class WorkManagerGcmService
extends GcmTaskService {
    private static final String TAG = "WorkManagerGcmService";
    private boolean mIsShutdown;
    private WorkManagerGcmDispatcher mGcmDispatcher;

    public void onCreate() {
        super.onCreate();
        this.initializeDispatcher();
    }

    @MainThread
    public void onInitializeTasks() {
        this.checkDispatcher();
        this.mGcmDispatcher.onInitializeTasks();
    }

    public int onRunTask(@NonNull TaskParams taskParams) {
        this.checkDispatcher();
        return this.mGcmDispatcher.onRunTask(taskParams);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mIsShutdown = true;
        this.mGcmDispatcher.onDestroy();
    }

    @MainThread
    private void checkDispatcher() {
        if (this.mIsShutdown) {
            Logger.get().debug(TAG, "Re-initializing dispatcher after a request to shutdown", new Throwable[0]);
            this.initializeDispatcher();
        }
    }

    @MainThread
    private void initializeDispatcher() {
        this.mIsShutdown = false;
        this.mGcmDispatcher = new WorkManagerGcmDispatcher(this.getApplicationContext(), new WorkTimer());
    }
}

