/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.ForegroundUpdater;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.ProgressUpdater;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkerStoppedException;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.RemoteWorkManagerInfo;
import androidx.work.multiprocess.RemoteWorkerWrapperKt;
import androidx.work.multiprocess.parcelable.ParcelConverters;
import androidx.work.multiprocess.parcelable.ParcelableInterruptRequest;
import androidx.work.multiprocess.parcelable.ParcelableRemoteWorkRequest;
import androidx.work.multiprocess.parcelable.ParcelableResult;
import androidx.work.multiprocess.parcelable.ParcelableWorkerParameters;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ListenableWorkerImpl
extends IListenableWorkerImpl.Stub {
    static final String TAG = Logger.tagWithPrefix((String)"WM-RemoteWorker ListenableWorkerImpl");
    static byte[] sEMPTY = new byte[0];
    static final Object sLock = new Object();
    final Context mContext;
    final Configuration mConfiguration;
    final TaskExecutor mTaskExecutor;
    final ProgressUpdater mProgressUpdater;
    final ForegroundUpdater mForegroundUpdater;
    final Map<String, Job> mRemoteWorkerWrapperMap;

    ListenableWorkerImpl(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        RemoteWorkManagerInfo remoteInfo = RemoteWorkManagerInfo.getInstance(context);
        this.mConfiguration = remoteInfo.getConfiguration();
        this.mTaskExecutor = remoteInfo.getTaskExecutor();
        this.mProgressUpdater = remoteInfo.getProgressUpdater();
        this.mForegroundUpdater = remoteInfo.getForegroundUpdater();
        this.mRemoteWorkerWrapperMap = new HashMap<String, Job>();
    }

    public void startWork(@NonNull byte[] request, final @NonNull IWorkManagerImplCallback callback) {
        try {
            ParcelableRemoteWorkRequest parcelableRemoteWorkRequest = ParcelConverters.unmarshall(request, ParcelableRemoteWorkRequest.CREATOR);
            ParcelableWorkerParameters parcelableWorkerParameters = parcelableRemoteWorkRequest.getParcelableWorkerParameters();
            WorkerParameters workerParameters = parcelableWorkerParameters.toWorkerParameters(this.mConfiguration, this.mTaskExecutor, this.mProgressUpdater, this.mForegroundUpdater);
            final String id = workerParameters.getId().toString();
            String workerClassName = parcelableRemoteWorkRequest.getWorkerClassName();
            Logger.get().debug(TAG, "Executing work request (" + id + ", " + workerClassName + ")");
            final ListenableFuture<ListenableWorker.Result> futureResult = this.executeWorkRequest(id, workerClassName, workerParameters);
            futureResult.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object result = (ListenableWorker.Result)futureResult.get();
                        ParcelableResult parcelableResult = new ParcelableResult((ListenableWorker.Result)result);
                        byte[] response = ParcelConverters.marshall(parcelableResult);
                        ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, response);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, exception);
                    }
                    catch (CancellationException cancellationException) {
                        Logger.get().debug(TAG, "Worker (" + id + ") was cancelled");
                        ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, cancellationException);
                    }
                    finally {
                        Object exception = sLock;
                        synchronized (exception) {
                            ListenableWorkerImpl.this.mRemoteWorkerWrapperMap.remove(id);
                        }
                    }
                }
            }, (Executor)this.mTaskExecutor.getSerialTaskExecutor());
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(@NonNull byte[] request, @NonNull IWorkManagerImplCallback callback) {
        try {
            Job workerJob;
            ParcelableInterruptRequest interruptRequest = ParcelConverters.unmarshall(request, ParcelableInterruptRequest.CREATOR);
            String id = interruptRequest.getId();
            int stopReason = interruptRequest.getStopReason();
            Logger.get().debug(TAG, "Interrupting work with id (" + id + ")");
            Object object = sLock;
            synchronized (object) {
                workerJob = this.mRemoteWorkerWrapperMap.remove(id);
            }
            if (workerJob != null) {
                this.mTaskExecutor.getSerialTaskExecutor().execute(() -> {
                    workerJob.cancel((CancellationException)new WorkerStoppedException(stopReason));
                    ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, sEMPTY);
                });
            } else {
                ListenableCallback.ListenableCallbackRunnable.reportSuccess(callback, sEMPTY);
            }
        }
        catch (Throwable throwable) {
            ListenableCallback.ListenableCallbackRunnable.reportFailure(callback, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<ListenableWorker.Result> executeWorkRequest(@NonNull String id, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        CompletableJob job = JobKt.Job(null);
        Object object = sLock;
        synchronized (object) {
            this.mRemoteWorkerWrapperMap.put(id, (Job)job);
        }
        return RemoteWorkerWrapperKt.executeRemoteWorker(this.mContext, this.mConfiguration, workerClassName, workerParameters, (Job)job, this.mTaskExecutor);
    }
}

