/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.RemoteDispatcher;
import androidx.work.multiprocess.RemoteExecuteKt;
import androidx.work.multiprocess.ServiceBindingKt;
import androidx.work.multiprocess.Session;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ListenableWorkerImplClient {
    static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImplClient");
    final Context mContext;
    final Executor mExecutor;
    private final Object mLock;
    private Session<IListenableWorkerImpl> mConnection;

    public ListenableWorkerImplClient(@NonNull Context context, @NonNull Executor executor) {
        this.mContext = context;
        this.mExecutor = executor;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenableFuture<IListenableWorkerImpl> getListenableWorkerImpl(@NonNull ComponentName component) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection == null) {
                Logger.get().debug(TAG, "Binding to " + component.getPackageName() + ", " + component.getClassName());
                Intent intent = new Intent();
                intent.setComponent(component);
                this.mConnection = ServiceBindingKt.bindToService(this.mContext, intent, IListenableWorkerImpl.Stub::asInterface, TAG);
            }
            return this.mConnection.getConnectedFuture();
        }
    }

    @NonNull
    public ListenableFuture<byte[]> execute(@NonNull ComponentName componentName, @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher) {
        ListenableFuture<IListenableWorkerImpl> session = this.getListenableWorkerImpl(componentName);
        return this.execute(session, dispatcher);
    }

    @NonNull
    @SuppressLint(value={"LambdaLast"})
    public ListenableFuture<byte[]> execute(@NonNull ListenableFuture<IListenableWorkerImpl> session, @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher) {
        return RemoteExecuteKt.execute(this.mExecutor, session, dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Session<IListenableWorkerImpl> getConnection() {
        return this.mConnection;
    }
}

