/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import com.google.common.util.concurrent.ListenableFuture;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RemoteCallback
extends IWorkManagerImplCallback.Stub {
    private final SettableFuture<byte[]> mFuture = SettableFuture.create();
    private IBinder mBinder = null;
    private final IBinder.DeathRecipient mRecipient = new DeathRecipient(this);

    @NonNull
    public ListenableFuture<byte[]> getFuture() {
        return this.mFuture;
    }

    public void setBinder(@NonNull IBinder binder) {
        this.mBinder = binder;
        try {
            this.mBinder.linkToDeath(this.mRecipient, 0);
        }
        catch (RemoteException exception) {
            this.onFailure(exception);
        }
    }

    public void onSuccess(@NonNull byte[] result) throws RemoteException {
        this.mFuture.set((Object)result);
        this.unlinkToDeath();
    }

    public void onFailure(@NonNull String error) {
        this.onFailure(new RuntimeException(error));
    }

    private void onFailure(@NonNull Throwable throwable) {
        this.mFuture.setException(throwable);
        this.unlinkToDeath();
    }

    private void unlinkToDeath() {
        if (this.mBinder != null) {
            this.mBinder.unlinkToDeath(this.mRecipient, 0);
        }
    }

    public static class DeathRecipient
    implements IBinder.DeathRecipient {
        private final RemoteCallback mCallback;

        public DeathRecipient(@NonNull RemoteCallback callback) {
            this.mCallback = callback;
        }

        public void binderDied() {
            this.mCallback.onFailure("Binder died");
        }
    }
}

