/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.multiprocess.parcelable.ParcelUtils;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableData
implements Parcelable {
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_BOOLEAN = 1;
    private static final byte TYPE_BYTE = 2;
    private static final byte TYPE_INTEGER = 3;
    private static final byte TYPE_LONG = 4;
    private static final byte TYPE_FLOAT = 5;
    private static final byte TYPE_DOUBLE = 6;
    private static final byte TYPE_STRING = 7;
    private static final byte TYPE_BOOLEAN_ARRAY = 8;
    private static final byte TYPE_BYTE_ARRAY = 9;
    private static final byte TYPE_INTEGER_ARRAY = 10;
    private static final byte TYPE_LONG_ARRAY = 11;
    private static final byte TYPE_FLOAT_ARRAY = 12;
    private static final byte TYPE_DOUBLE_ARRAY = 13;
    private static final byte TYPE_STRING_ARRAY = 14;
    private final Data mData;
    public static final Parcelable.Creator<ParcelableData> CREATOR = new Parcelable.Creator<ParcelableData>(){

        public ParcelableData createFromParcel(@NonNull Parcel in) {
            return new ParcelableData(in);
        }

        public ParcelableData[] newArray(int size) {
            return new ParcelableData[size];
        }
    };

    public ParcelableData(@NonNull Data data) {
        this.mData = data;
    }

    protected ParcelableData(@NonNull Parcel in) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.addEntry(in, values);
        }
        this.mData = new Data(values);
    }

    @NonNull
    public Data getData() {
        return this.mData;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        Map keyValueMap = this.mData.getKeyValueMap();
        parcel.writeInt(keyValueMap.size());
        for (Map.Entry entry : keyValueMap.entrySet()) {
            this.writeToParcel(parcel, (String)entry.getKey(), entry.getValue());
        }
    }

    private void writeToParcel(@NonNull Parcel parcel, @NonNull String key, @Nullable Object value) {
        if (value == null) {
            parcel.writeByte((byte)0);
        } else {
            Class<?> valueType = value.getClass();
            if (valueType == Boolean.class) {
                parcel.writeByte((byte)1);
                boolean booleanValue = (Boolean)value;
                ParcelUtils.writeBooleanValue(parcel, booleanValue);
            } else if (valueType == Byte.class) {
                parcel.writeByte((byte)2);
                byte byteValue = (Byte)value;
                parcel.writeByte(byteValue);
            } else if (valueType == Integer.class) {
                parcel.writeByte((byte)3);
                int intValue = (Integer)value;
                parcel.writeInt(intValue);
            } else if (valueType == Long.class) {
                parcel.writeByte((byte)4);
                Long longValue = (Long)value;
                parcel.writeLong(longValue.longValue());
            } else if (valueType == Float.class) {
                parcel.writeByte((byte)5);
                float floatValue = ((Float)value).floatValue();
                parcel.writeFloat(floatValue);
            } else if (valueType == Double.class) {
                parcel.writeByte((byte)6);
                double doubleValue = (Double)value;
                parcel.writeDouble(doubleValue);
            } else if (valueType == String.class) {
                parcel.writeByte((byte)7);
                String stringValue = (String)value;
                parcel.writeString(stringValue);
            } else if (valueType == Boolean[].class) {
                parcel.writeByte((byte)8);
                Boolean[] booleanArray = (Boolean[])value;
                parcel.writeBooleanArray(Data.convertToPrimitiveArray((Boolean[])booleanArray));
            } else if (valueType == Byte[].class) {
                parcel.writeByte((byte)9);
                Byte[] byteArray = (Byte[])value;
                parcel.writeByteArray(Data.convertToPrimitiveArray((Byte[])byteArray));
            } else if (valueType == Integer[].class) {
                parcel.writeByte((byte)10);
                Integer[] integerArray = (Integer[])value;
                parcel.writeIntArray(Data.convertToPrimitiveArray((Integer[])integerArray));
            } else if (valueType == Long[].class) {
                parcel.writeByte((byte)11);
                Long[] longArray = (Long[])value;
                parcel.writeLongArray(Data.convertToPrimitiveArray((Long[])longArray));
            } else if (valueType == Float[].class) {
                parcel.writeByte((byte)12);
                Float[] floatArray = (Float[])value;
                parcel.writeFloatArray(Data.convertToPrimitiveArray((Float[])floatArray));
            } else if (valueType == Double[].class) {
                parcel.writeByte((byte)13);
                Double[] doubleArray = (Double[])value;
                parcel.writeDoubleArray(Data.convertToPrimitiveArray((Double[])doubleArray));
            } else if (valueType == String[].class) {
                parcel.writeByte((byte)14);
                String[] stringArray = (String[])value;
                parcel.writeStringArray(stringArray);
            } else {
                String message = String.format("Unsupported value type %s", valueType.getName());
                throw new IllegalArgumentException(message);
            }
        }
        parcel.writeString(key);
    }

    private void addEntry(@NonNull Parcel parcel, @NonNull Map<String, Object> values) {
        byte type = parcel.readByte();
        Object value = null;
        switch (type) {
            case 0: {
                break;
            }
            case 2: {
                value = parcel.readByte();
                break;
            }
            case 1: {
                value = ParcelUtils.readBooleanValue(parcel);
                break;
            }
            case 3: {
                value = parcel.readInt();
                break;
            }
            case 4: {
                value = parcel.readLong();
                break;
            }
            case 5: {
                value = Float.valueOf(parcel.readFloat());
                break;
            }
            case 6: {
                value = parcel.readDouble();
                break;
            }
            case 7: {
                value = parcel.readString();
                break;
            }
            case 8: {
                value = Data.convertPrimitiveBooleanArray((boolean[])parcel.createBooleanArray());
                break;
            }
            case 9: {
                value = Data.convertPrimitiveByteArray((byte[])parcel.createByteArray());
                break;
            }
            case 10: {
                value = Data.convertPrimitiveIntArray((int[])parcel.createIntArray());
                break;
            }
            case 11: {
                value = Data.convertPrimitiveLongArray((long[])parcel.createLongArray());
                break;
            }
            case 12: {
                value = Data.convertPrimitiveFloatArray((float[])parcel.createFloatArray());
                break;
            }
            case 13: {
                value = Data.convertPrimitiveDoubleArray((double[])parcel.createDoubleArray());
                break;
            }
            case 14: {
                value = parcel.createStringArray();
                break;
            }
            default: {
                String message = String.format("Unsupported type %s", type);
                throw new IllegalStateException(message);
            }
        }
        String key = parcel.readString();
        values.put(key, value);
    }
}

