/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.multiprocess.IListenableWorkerImpl;
import androidx.work.multiprocess.IWorkManagerImplCallback;
import androidx.work.multiprocess.ListenableCallback;
import androidx.work.multiprocess.RemoteCallback;
import androidx.work.multiprocess.RemoteDispatcher;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ListenableWorkerImplClient {
    static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImplClient");
    final Context mContext;
    final Executor mExecutor;

    public ListenableWorkerImplClient(@NonNull Context context, @NonNull Executor executor) {
        this.mContext = context;
        this.mExecutor = executor;
    }

    @NonNull
    public ListenableFuture<IListenableWorkerImpl> getListenableWorkerImpl(@NonNull ComponentName component) {
        Logger.get().debug(TAG, String.format("Binding to %s, %s", component.getPackageName(), component.getClassName()), new Throwable[0]);
        Connection session = new Connection();
        try {
            Intent intent = new Intent();
            intent.setComponent(component);
            boolean bound = this.mContext.bindService(intent, (ServiceConnection)session, 1);
            if (!bound) {
                ListenableWorkerImplClient.unableToBind(session, new RuntimeException("Unable to bind to service"));
            }
        }
        catch (Throwable throwable) {
            ListenableWorkerImplClient.unableToBind(session, throwable);
        }
        return session.mFuture;
    }

    @NonNull
    public ListenableFuture<byte[]> execute(@NonNull ComponentName componentName, @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher) {
        ListenableFuture<IListenableWorkerImpl> session = this.getListenableWorkerImpl(componentName);
        return this.execute(session, dispatcher, new RemoteCallback());
    }

    @NonNull
    @SuppressLint(value={"LambdaLast"})
    public ListenableFuture<byte[]> execute(final @NonNull ListenableFuture<IListenableWorkerImpl> session, final @NonNull RemoteDispatcher<IListenableWorkerImpl> dispatcher, final @NonNull RemoteCallback callback) {
        session.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final IListenableWorkerImpl iListenableWorker = (IListenableWorkerImpl)session.get();
                    callback.setBinder(iListenableWorker.asBinder());
                    ListenableWorkerImplClient.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                dispatcher.execute(iListenableWorker, (IWorkManagerImplCallback)callback);
                            }
                            catch (Throwable innerThrowable) {
                                Logger.get().error(TAG, "Unable to execute", new Throwable[]{innerThrowable});
                                ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, innerThrowable);
                            }
                        }
                    });
                }
                catch (InterruptedException | ExecutionException exception) {
                    String message = "Unable to bind to service";
                    Logger.get().error(TAG, message, new Throwable[]{exception});
                    ListenableCallback.ListenableCallbackRunnable.reportFailure((IWorkManagerImplCallback)callback, exception);
                }
            }
        }, this.mExecutor);
        return callback.getFuture();
    }

    private static void unableToBind(@NonNull Connection session, @NonNull Throwable throwable) {
        Logger.get().error(TAG, "Unable to bind to service", new Throwable[]{throwable});
        session.mFuture.setException(throwable);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Connection
    implements ServiceConnection {
        private static final String TAG = Logger.tagWithPrefix((String)"ListenableWorkerImplSession");
        final SettableFuture<IListenableWorkerImpl> mFuture = SettableFuture.create();

        public void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
            Logger.get().debug(TAG, "Service connected", new Throwable[0]);
            IListenableWorkerImpl iListenableWorkerImpl = IListenableWorkerImpl.Stub.asInterface((IBinder)iBinder);
            this.mFuture.set((Object)iListenableWorkerImpl);
        }

        public void onServiceDisconnected(@NonNull ComponentName componentName) {
            Logger.get().warning(TAG, "Service disconnected", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException("Service disconnected"));
        }

        public void onBindingDied(@NonNull ComponentName name) {
            Logger.get().warning(TAG, "Binding died", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException("Binding died"));
        }

        public void onNullBinding(@NonNull ComponentName name) {
            Logger.get().error(TAG, "Unable to bind to service", new Throwable[0]);
            this.mFuture.setException((Throwable)new RuntimeException(String.format("Cannot bind to service %s", name)));
        }
    }
}

