/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.ForegroundUpdater;
import androidx.work.ProgressUpdater;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.impl.utils.taskexecutor.WorkManagerTaskExecutor;
import androidx.work.multiprocess.RemoteForegroundUpdater;
import androidx.work.multiprocess.RemoteProgressUpdater;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RemoteWorkManagerInfo {
    private static final Object sLock = new Object();
    private static volatile RemoteWorkManagerInfo sInstance;
    private final Configuration mConfiguration;
    private final TaskExecutor mTaskExecutor;
    private final ProgressUpdater mProgressUpdater;
    private final ForegroundUpdater mForegroundUpdater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static RemoteWorkManagerInfo getInstance(@NonNull Context context) {
        if (sInstance == null) {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new RemoteWorkManagerInfo(context);
                }
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearInstance() {
        Object object = sLock;
        synchronized (object) {
            sInstance = null;
        }
    }

    private RemoteWorkManagerInfo(@NonNull Context context) {
        WorkManagerImpl instance = WorkManagerImpl.getInstance();
        if (instance != null) {
            this.mConfiguration = instance.getConfiguration();
            this.mTaskExecutor = instance.getWorkTaskExecutor();
        } else {
            Context appContext = context.getApplicationContext();
            if (appContext instanceof Configuration.Provider) {
                Configuration.Provider provider = (Configuration.Provider)appContext;
                this.mConfiguration = provider.getWorkManagerConfiguration();
            } else {
                this.mConfiguration = new Configuration.Builder().setDefaultProcessName(appContext.getPackageName()).build();
            }
            this.mTaskExecutor = new WorkManagerTaskExecutor(this.mConfiguration.getTaskExecutor());
        }
        this.mProgressUpdater = new RemoteProgressUpdater();
        this.mForegroundUpdater = new RemoteForegroundUpdater();
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    @NonNull
    public TaskExecutor getTaskExecutor() {
        return this.mTaskExecutor;
    }

    @NonNull
    public ProgressUpdater getProgressUpdater() {
        return this.mProgressUpdater;
    }

    @NonNull
    public ForegroundUpdater getForegroundUpdater() {
        return this.mForegroundUpdater;
    }
}

