/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.ForegroundInfo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableForegroundRequestInfo
implements Parcelable {
    private final String mId;
    private final ForegroundInfo mForegroundInfo;
    public static final Parcelable.Creator<ParcelableForegroundRequestInfo> CREATOR = new Parcelable.Creator<ParcelableForegroundRequestInfo>(){

        public ParcelableForegroundRequestInfo createFromParcel(Parcel in) {
            return new ParcelableForegroundRequestInfo(in);
        }

        public ParcelableForegroundRequestInfo[] newArray(int size) {
            return new ParcelableForegroundRequestInfo[size];
        }
    };

    public ParcelableForegroundRequestInfo(@NonNull String id, @NonNull ForegroundInfo foregroundInfo) {
        this.mId = id;
        this.mForegroundInfo = foregroundInfo;
    }

    public ParcelableForegroundRequestInfo(@NonNull Parcel in) {
        this.mId = in.readString();
        int notificationId = in.readInt();
        int foregroundServiceType = in.readInt();
        Notification notification = (Notification)in.readParcelable(this.getClass().getClassLoader());
        this.mForegroundInfo = new ForegroundInfo(notificationId, notification, foregroundServiceType);
    }

    @NonNull
    public ForegroundInfo getForegroundInfo() {
        return this.mForegroundInfo;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeString(this.mId);
        parcel.writeInt(this.mForegroundInfo.getNotificationId());
        parcel.writeInt(this.mForegroundInfo.getForegroundServiceType());
        parcel.writeParcelable((Parcelable)this.mForegroundInfo.getNotification(), flags);
    }
}

