/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkTypeConverters;
import androidx.work.multiprocess.parcelable.ParcelableData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableWorkInfo
implements Parcelable {
    private static final String[] sEMPTY = new String[0];
    private final WorkInfo mWorkInfo;
    public static final Parcelable.Creator<ParcelableWorkInfo> CREATOR = new Parcelable.Creator<ParcelableWorkInfo>(){

        public ParcelableWorkInfo createFromParcel(Parcel in) {
            return new ParcelableWorkInfo(in);
        }

        public ParcelableWorkInfo[] newArray(int size) {
            return new ParcelableWorkInfo[size];
        }
    };

    public ParcelableWorkInfo(@NonNull WorkInfo workInfo) {
        this.mWorkInfo = workInfo;
    }

    protected ParcelableWorkInfo(@NonNull Parcel parcel) {
        UUID id = UUID.fromString(parcel.readString());
        WorkInfo.State state = WorkTypeConverters.intToState((int)parcel.readInt());
        ParcelableData parcelableOutputData = new ParcelableData(parcel);
        Data output = parcelableOutputData.getData();
        String[] tagsArray = parcel.createStringArray();
        HashSet<String> tags = new HashSet<String>(Arrays.asList(tagsArray));
        ParcelableData parcelableProgressData = new ParcelableData(parcel);
        Data progress = parcelableProgressData.getData();
        int runAttemptCount = parcel.readInt();
        int generation = parcel.readInt();
        this.mWorkInfo = new WorkInfo(id, state, tags, output, progress, runAttemptCount, generation);
    }

    @NonNull
    public WorkInfo getWorkInfo() {
        return this.mWorkInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeString(this.mWorkInfo.getId().toString());
        parcel.writeInt(WorkTypeConverters.stateToInt((WorkInfo.State)this.mWorkInfo.getState()));
        ParcelableData parcelableOutputData = new ParcelableData(this.mWorkInfo.getOutputData());
        parcelableOutputData.writeToParcel(parcel, flags);
        ArrayList tags = new ArrayList(this.mWorkInfo.getTags());
        parcel.writeStringArray(tags.toArray(sEMPTY));
        ParcelableData parcelableProgress = new ParcelableData(this.mWorkInfo.getProgress());
        parcelableProgress.writeToParcel(parcel, flags);
        parcel.writeInt(this.mWorkInfo.getRunAttemptCount());
        parcel.writeInt(this.mWorkInfo.getGeneration());
    }
}

