/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.ContentUriTriggers;
import androidx.work.Logger;
import androidx.work.NetworkType;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.WorkSpec;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(api=23)
class SystemJobInfoConverter {
    private static final String TAG = Logger.tagWithPrefix("SystemJobInfoConverter");
    static final String EXTRA_WORK_SPEC_ID = "EXTRA_WORK_SPEC_ID";
    static final String EXTRA_IS_PERIODIC = "EXTRA_IS_PERIODIC";
    private final ComponentName mWorkServiceComponent;

    @VisibleForTesting(otherwise=3)
    SystemJobInfoConverter(@NonNull Context context) {
        Context appContext = context.getApplicationContext();
        this.mWorkServiceComponent = new ComponentName(appContext, SystemJobService.class);
    }

    JobInfo convert(WorkSpec workSpec, int jobId) {
        Constraints constraints = workSpec.constraints;
        int jobInfoNetworkType = SystemJobInfoConverter.convertNetworkType(constraints.getRequiredNetworkType());
        PersistableBundle extras = new PersistableBundle();
        extras.putString(EXTRA_WORK_SPEC_ID, workSpec.id);
        extras.putBoolean(EXTRA_IS_PERIODIC, workSpec.isPeriodic());
        JobInfo.Builder builder = new JobInfo.Builder(jobId, this.mWorkServiceComponent).setRequiredNetworkType(jobInfoNetworkType).setRequiresCharging(constraints.requiresCharging()).setRequiresDeviceIdle(constraints.requiresDeviceIdle()).setExtras(extras);
        if (!constraints.requiresDeviceIdle()) {
            int backoffPolicy = workSpec.backoffPolicy == BackoffPolicy.LINEAR ? 0 : 1;
            builder.setBackoffCriteria(workSpec.backoffDelayDuration, backoffPolicy);
        }
        if (workSpec.isPeriodic()) {
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setPeriodic(workSpec.intervalDuration, workSpec.flexDuration);
            } else {
                Logger.get().debug(TAG, "Flex duration is currently not supported before API 24. Ignoring.", new Throwable[0]);
                builder.setPeriodic(workSpec.intervalDuration);
            }
        } else {
            builder.setMinimumLatency(workSpec.initialDelay);
        }
        if (Build.VERSION.SDK_INT >= 24 && constraints.hasContentUriTriggers()) {
            ContentUriTriggers contentUriTriggers = constraints.getContentUriTriggers();
            for (ContentUriTriggers.Trigger trigger : contentUriTriggers.getTriggers()) {
                builder.addTriggerContentUri(SystemJobInfoConverter.convertContentUriTrigger(trigger));
            }
            builder.setTriggerContentUpdateDelay(constraints.getTriggerContentUpdateDelay());
            builder.setTriggerContentMaxDelay(constraints.getTriggerMaxContentDelay());
        }
        builder.setPersisted(false);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setRequiresBatteryNotLow(constraints.requiresBatteryNotLow());
            builder.setRequiresStorageNotLow(constraints.requiresStorageNotLow());
        }
        return builder.build();
    }

    @RequiresApi(value=24)
    private static JobInfo.TriggerContentUri convertContentUriTrigger(ContentUriTriggers.Trigger trigger) {
        int flag = trigger.shouldTriggerForDescendants() ? 1 : 0;
        return new JobInfo.TriggerContentUri(trigger.getUri(), flag);
    }

    static int convertNetworkType(NetworkType networkType) {
        switch (networkType) {
            case NOT_REQUIRED: {
                return 0;
            }
            case CONNECTED: {
                return 1;
            }
            case UNMETERED: {
                return 2;
            }
            case NOT_ROAMING: {
                if (Build.VERSION.SDK_INT < 24) break;
                return 3;
            }
            case METERED: {
                if (Build.VERSION.SDK_INT < 26) break;
                return 4;
            }
        }
        Logger.get().debug(TAG, String.format("API version too low. Cannot convert network type value %s", new Object[]{networkType}), new Throwable[0]);
        return 1;
    }
}

