/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Preferences {
    private static final String PREFERENCES_FILE_NAME = "androidx.work.util.preferences";
    private static final String KEY_LAST_CANCEL_ALL_TIME_MS = "last_cancel_all_time_ms";
    private static final String KEY_RESCHEDULE_NEEDED = "reschedule_needed";
    private Context mContext;
    private SharedPreferences mSharedPreferences;

    public Preferences(@NonNull Context context) {
        this.mContext = context;
    }

    @VisibleForTesting
    public Preferences(@NonNull SharedPreferences preferences) {
        this.mSharedPreferences = preferences;
    }

    public long getLastCancelAllTimeMillis() {
        return this.getSharedPreferences().getLong(KEY_LAST_CANCEL_ALL_TIME_MS, 0L);
    }

    public LiveData<Long> getLastCancelAllTimeMillisLiveData() {
        return new LastCancelAllLiveData(this.getSharedPreferences());
    }

    public void setLastCancelAllTimeMillis(long timeMillis) {
        this.getSharedPreferences().edit().putLong(KEY_LAST_CANCEL_ALL_TIME_MS, timeMillis).apply();
    }

    public boolean needsReschedule() {
        return this.getSharedPreferences().getBoolean(KEY_RESCHEDULE_NEEDED, false);
    }

    public void setNeedsReschedule(boolean needsReschedule) {
        this.getSharedPreferences().edit().putBoolean(KEY_RESCHEDULE_NEEDED, needsReschedule).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedPreferences getSharedPreferences() {
        Class<Preferences> clazz = Preferences.class;
        synchronized (Preferences.class) {
            if (this.mSharedPreferences == null) {
                this.mSharedPreferences = this.mContext.getSharedPreferences(PREFERENCES_FILE_NAME, 0);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mSharedPreferences;
        }
    }

    private static class LastCancelAllLiveData
    extends MutableLiveData<Long>
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private SharedPreferences mSharedPreferences;
        private long mLastCancelAllTimeMillis;

        LastCancelAllLiveData(SharedPreferences sharedPreferences) {
            this.mSharedPreferences = sharedPreferences;
            this.mLastCancelAllTimeMillis = this.mSharedPreferences.getLong(Preferences.KEY_LAST_CANCEL_ALL_TIME_MS, 0L);
            this.postValue(this.mLastCancelAllTimeMillis);
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            long lastCancelAllTimeMillis;
            if (Preferences.KEY_LAST_CANCEL_ALL_TIME_MS.equals(key) && this.mLastCancelAllTimeMillis != (lastCancelAllTimeMillis = sharedPreferences.getLong(key, 0L))) {
                this.mLastCancelAllTimeMillis = lastCancelAllTimeMillis;
                this.setValue(this.mLastCancelAllTimeMillis);
            }
        }

        protected void onActive() {
            super.onActive();
            this.mSharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }

        protected void onInactive() {
            super.onInactive();
            this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
    }
}

