/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class WorkInfo {
    @NonNull
    private UUID mId;
    @NonNull
    private State mState;
    @NonNull
    private Data mOutputData;
    @NonNull
    private Set<String> mTags;
    private int mRunAttemptCount;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public WorkInfo(@NonNull UUID id, @NonNull State state, @NonNull Data outputData, @NonNull List<String> tags, int runAttemptCount) {
        this.mId = id;
        this.mState = state;
        this.mOutputData = outputData;
        this.mTags = new HashSet<String>(tags);
        this.mRunAttemptCount = runAttemptCount;
    }

    @NonNull
    public UUID getId() {
        return this.mId;
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    @NonNull
    public Data getOutputData() {
        return this.mOutputData;
    }

    @NonNull
    public Set<String> getTags() {
        return this.mTags;
    }

    @IntRange(from=0L)
    public int getRunAttemptCount() {
        return this.mRunAttemptCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkInfo workInfo = (WorkInfo)o;
        if (this.mRunAttemptCount != workInfo.mRunAttemptCount) {
            return false;
        }
        if (!this.mId.equals(workInfo.mId)) {
            return false;
        }
        if (this.mState != workInfo.mState) {
            return false;
        }
        if (!this.mOutputData.equals(workInfo.mOutputData)) {
            return false;
        }
        return this.mTags.equals(workInfo.mTags);
    }

    public int hashCode() {
        int result = this.mId.hashCode();
        result = 31 * result + this.mState.hashCode();
        result = 31 * result + this.mOutputData.hashCode();
        result = 31 * result + this.mTags.hashCode();
        result = 31 * result + this.mRunAttemptCount;
        return result;
    }

    public String toString() {
        return "WorkInfo{mId='" + this.mId + '\'' + ", mState=" + (Object)((Object)this.mState) + ", mOutputData=" + this.mOutputData + ", mTags=" + this.mTags + '}';
    }

    public static enum State {
        ENQUEUED,
        RUNNING,
        SUCCEEDED,
        FAILED,
        BLOCKED,
        CANCELLED;


        public boolean isFinished() {
            return this == SUCCEEDED || this == FAILED || this == CANCELLED;
        }
    }
}

