/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.annotation.SuppressLint;
import android.app.job.JobInfo;
import android.content.ComponentName;
import android.content.Context;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.work.BackoffPolicy;
import androidx.work.Clock;
import androidx.work.Constraints;
import androidx.work.Logger;
import androidx.work.NetworkType;
import androidx.work.impl.background.systemjob.SystemJobInfoConverterExtKt;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.WorkSpec;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(api=23)
@SuppressLint(value={"ClassVerificationFailure"})
class SystemJobInfoConverter {
    private static final String TAG = Logger.tagWithPrefix("SystemJobInfoConverter");
    static final String EXTRA_WORK_SPEC_ID = "EXTRA_WORK_SPEC_ID";
    static final String EXTRA_IS_PERIODIC = "EXTRA_IS_PERIODIC";
    static final String EXTRA_WORK_SPEC_GENERATION = "EXTRA_WORK_SPEC_GENERATION";
    private final ComponentName mWorkServiceComponent;
    private final Clock mClock;

    SystemJobInfoConverter(@NonNull Context context, Clock clock) {
        this.mClock = clock;
        Context appContext = context.getApplicationContext();
        this.mWorkServiceComponent = new ComponentName(appContext, SystemJobService.class);
    }

    JobInfo convert(WorkSpec workSpec, int jobId) {
        boolean isDelayed;
        Constraints constraints = workSpec.constraints;
        PersistableBundle extras = new PersistableBundle();
        extras.putString(EXTRA_WORK_SPEC_ID, workSpec.id);
        extras.putInt(EXTRA_WORK_SPEC_GENERATION, workSpec.getGeneration());
        extras.putBoolean(EXTRA_IS_PERIODIC, workSpec.isPeriodic());
        JobInfo.Builder builder = new JobInfo.Builder(jobId, this.mWorkServiceComponent).setRequiresCharging(constraints.requiresCharging()).setRequiresDeviceIdle(constraints.requiresDeviceIdle()).setExtras(extras);
        NetworkRequest networkRequest = constraints.getRequiredNetworkRequest();
        if (Build.VERSION.SDK_INT >= 28 && networkRequest != null) {
            SystemJobInfoConverterExtKt.setRequiredNetworkRequest(builder, networkRequest);
        } else {
            SystemJobInfoConverter.setRequiredNetwork(builder, constraints.getRequiredNetworkType());
        }
        if (!constraints.requiresDeviceIdle()) {
            int backoffPolicy = workSpec.backoffPolicy == BackoffPolicy.LINEAR ? 0 : 1;
            builder.setBackoffCriteria(workSpec.backoffDelayDuration, backoffPolicy);
        }
        long nextRunTime = workSpec.calculateNextRunTime();
        long now = this.mClock.currentTimeMillis();
        long offset = Math.max(nextRunTime - now, 0L);
        if (Build.VERSION.SDK_INT <= 28) {
            builder.setMinimumLatency(offset);
        } else if (offset > 0L) {
            builder.setMinimumLatency(offset);
        } else if (!workSpec.expedited) {
            builder.setImportantWhileForeground(true);
        }
        if (Build.VERSION.SDK_INT >= 24 && constraints.hasContentUriTriggers()) {
            for (Constraints.ContentUriTrigger trigger : constraints.getContentUriTriggers()) {
                builder.addTriggerContentUri(SystemJobInfoConverter.convertContentUriTrigger(trigger));
            }
            builder.setTriggerContentUpdateDelay(constraints.getContentTriggerUpdateDelayMillis());
            builder.setTriggerContentMaxDelay(constraints.getContentTriggerMaxDelayMillis());
        }
        builder.setPersisted(false);
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setRequiresBatteryNotLow(constraints.requiresBatteryNotLow());
            builder.setRequiresStorageNotLow(constraints.requiresStorageNotLow());
        }
        boolean isRetry = workSpec.runAttemptCount > 0;
        boolean bl = isDelayed = offset > 0L;
        if (Build.VERSION.SDK_INT >= 31 && workSpec.expedited && !isRetry && !isDelayed) {
            builder.setExpedited(true);
        }
        return builder.build();
    }

    @RequiresApi(value=24)
    private static JobInfo.TriggerContentUri convertContentUriTrigger(Constraints.ContentUriTrigger trigger) {
        int flag = trigger.isTriggeredForDescendants() ? 1 : 0;
        return new JobInfo.TriggerContentUri(trigger.getUri(), flag);
    }

    static void setRequiredNetwork(@NonNull JobInfo.Builder builder, @NonNull NetworkType networkType) {
        if (Build.VERSION.SDK_INT >= 30 && networkType == NetworkType.TEMPORARILY_UNMETERED) {
            NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(25).build();
            builder.setRequiredNetwork(networkRequest);
        } else {
            builder.setRequiredNetworkType(SystemJobInfoConverter.convertNetworkType(networkType));
        }
    }

    static int convertNetworkType(NetworkType networkType) {
        switch (networkType) {
            case NOT_REQUIRED: {
                return 0;
            }
            case CONNECTED: {
                return 1;
            }
            case UNMETERED: {
                return 2;
            }
            case NOT_ROAMING: {
                if (Build.VERSION.SDK_INT < 24) break;
                return 3;
            }
            case METERED: {
                if (Build.VERSION.SDK_INT < 26) break;
                return 4;
            }
        }
        Logger.get().debug(TAG, "API version too low. Cannot convert network type value " + (Object)((Object)networkType));
        return 1;
    }
}

