/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.SystemIdInfoKt;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.utils.IdGenerator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class Alarms {
    private static final String TAG = Logger.tagWithPrefix("Alarms");

    public static void setAlarm(@NonNull Context context, @NonNull WorkDatabase workDatabase, @NonNull WorkGenerationalId id, long triggerAtMillis) {
        SystemIdInfoDao systemIdInfoDao = workDatabase.systemIdInfoDao();
        SystemIdInfo systemIdInfo = systemIdInfoDao.getSystemIdInfo(id);
        if (systemIdInfo != null) {
            Alarms.cancelExactAlarm(context, id, systemIdInfo.systemId);
            Alarms.setExactAlarm(context, id, systemIdInfo.systemId, triggerAtMillis);
        } else {
            IdGenerator idGenerator = new IdGenerator(workDatabase);
            int alarmId = idGenerator.nextAlarmManagerId();
            SystemIdInfo newSystemIdInfo = SystemIdInfoKt.systemIdInfo(id, alarmId);
            systemIdInfoDao.insertSystemIdInfo(newSystemIdInfo);
            Alarms.setExactAlarm(context, id, alarmId, triggerAtMillis);
        }
    }

    public static void cancelAlarm(@NonNull Context context, @NonNull WorkDatabase workDatabase, @NonNull WorkGenerationalId id) {
        SystemIdInfoDao systemIdInfoDao = workDatabase.systemIdInfoDao();
        SystemIdInfo systemIdInfo = systemIdInfoDao.getSystemIdInfo(id);
        if (systemIdInfo != null) {
            Alarms.cancelExactAlarm(context, id, systemIdInfo.systemId);
            Logger.get().debug(TAG, "Removing SystemIdInfo for workSpecId (" + id + ")");
            systemIdInfoDao.removeSystemIdInfo(id);
        }
    }

    private static void cancelExactAlarm(@NonNull Context context, @NonNull WorkGenerationalId id, int alarmId) {
        PendingIntent pendingIntent;
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        Intent delayMet = CommandHandler.createDelayMetIntent(context, id);
        int flags = 0x20000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        if ((pendingIntent = PendingIntent.getService((Context)context, (int)alarmId, (Intent)delayMet, (int)flags)) != null && alarmManager != null) {
            Logger.get().debug(TAG, "Cancelling existing alarm with (workSpecId, systemId) (" + id + ", " + alarmId + ")");
            alarmManager.cancel(pendingIntent);
        }
    }

    private static void setExactAlarm(@NonNull Context context, @NonNull WorkGenerationalId id, int alarmId, long triggerAtMillis) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        Intent delayMet = CommandHandler.createDelayMetIntent(context, id);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)alarmId, (Intent)delayMet, (int)flags);
        if (alarmManager != null) {
            alarmManager.setExact(0, triggerAtMillis, pendingIntent);
        }
    }

    private Alarms() {
    }
}

