/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemjob.SystemJobInfoConverter;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.IdGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
public class SystemJobScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix("SystemJobScheduler");
    private final Context mContext;
    private final JobScheduler mJobScheduler;
    private final WorkManagerImpl mWorkManager;
    private final SystemJobInfoConverter mSystemJobInfoConverter;

    public SystemJobScheduler(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this(context, workManager, (JobScheduler)context.getSystemService("jobscheduler"), new SystemJobInfoConverter(context));
    }

    @VisibleForTesting
    public SystemJobScheduler(Context context, WorkManagerImpl workManager, JobScheduler jobScheduler, SystemJobInfoConverter systemJobInfoConverter) {
        this.mContext = context;
        this.mWorkManager = workManager;
        this.mJobScheduler = jobScheduler;
        this.mSystemJobInfoConverter = systemJobInfoConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        WorkDatabase workDatabase = this.mWorkManager.getWorkDatabase();
        IdGenerator idGenerator = new IdGenerator(workDatabase);
        for (WorkSpec workSpec : workSpecs) {
            workDatabase.beginTransaction();
            try {
                List<Integer> jobIds;
                int jobId;
                WorkSpec currentDbWorkSpec = workDatabase.workSpecDao().getWorkSpec(workSpec.id);
                if (currentDbWorkSpec == null) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it's no longer in the DB", new Throwable[0]);
                    workDatabase.setTransactionSuccessful();
                    continue;
                }
                if (currentDbWorkSpec.state != WorkInfo.State.ENQUEUED) {
                    Logger.get().warning(TAG, "Skipping scheduling " + workSpec.id + " because it is no longer enqueued", new Throwable[0]);
                    workDatabase.setTransactionSuccessful();
                    continue;
                }
                SystemIdInfo info = workDatabase.systemIdInfoDao().getSystemIdInfo(workSpec.id);
                int n = jobId = info != null ? info.systemId : idGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                if (info == null) {
                    SystemIdInfo newSystemIdInfo = new SystemIdInfo(workSpec.id, jobId);
                    this.mWorkManager.getWorkDatabase().systemIdInfoDao().insertSystemIdInfo(newSystemIdInfo);
                }
                this.scheduleInternal(workSpec, jobId);
                if (Build.VERSION.SDK_INT == 23 && (jobIds = SystemJobScheduler.getPendingJobIds(this.mContext, this.mJobScheduler, workSpec.id)) != null) {
                    int index = jobIds.indexOf(jobId);
                    if (index >= 0) {
                        jobIds.remove(index);
                    }
                    int nextJobId = !jobIds.isEmpty() ? jobIds.get(0).intValue() : idGenerator.nextJobSchedulerIdWithRange(this.mWorkManager.getConfiguration().getMinJobSchedulerId(), this.mWorkManager.getConfiguration().getMaxJobSchedulerId());
                    this.scheduleInternal(workSpec, nextJobId);
                }
                workDatabase.setTransactionSuccessful();
            }
            finally {
                workDatabase.endTransaction();
            }
        }
    }

    @VisibleForTesting
    public void scheduleInternal(WorkSpec workSpec, int jobId) {
        JobInfo jobInfo = this.mSystemJobInfoConverter.convert(workSpec, jobId);
        Logger.get().debug(TAG, String.format("Scheduling work ID %s Job ID %s", workSpec.id, jobId), new Throwable[0]);
        try {
            this.mJobScheduler.schedule(jobInfo);
        }
        catch (IllegalStateException e) {
            List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(this.mContext, this.mJobScheduler);
            int numWorkManagerJobs = jobs != null ? jobs.size() : 0;
            String message = String.format(Locale.getDefault(), "JobScheduler 100 job limit exceeded.  We count %d WorkManager jobs in JobScheduler; we have %d tracked jobs in our DB; our Configuration limit is %d.", numWorkManagerJobs, this.mWorkManager.getWorkDatabase().workSpecDao().getScheduledWork().size(), this.mWorkManager.getConfiguration().getMaxSchedulerLimit());
            Logger.get().error(TAG, message, new Throwable[0]);
            throw new IllegalStateException(message, e);
        }
        catch (Throwable throwable) {
            Logger.get().error(TAG, String.format("Unable to schedule %s", workSpec), throwable);
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        List<Integer> jobIds = SystemJobScheduler.getPendingJobIds(this.mContext, this.mJobScheduler, workSpecId);
        if (jobIds != null && !jobIds.isEmpty()) {
            for (int jobId : jobIds) {
                SystemJobScheduler.cancelJobById(this.mJobScheduler, jobId);
            }
            this.mWorkManager.getWorkDatabase().systemIdInfoDao().removeSystemIdInfo(workSpecId);
        }
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return true;
    }

    private static void cancelJobById(@NonNull JobScheduler jobScheduler, int id) {
        try {
            jobScheduler.cancel(id);
        }
        catch (Throwable throwable) {
            Logger.get().error(TAG, String.format(Locale.getDefault(), "Exception while trying to cancel job (%d)", id), throwable);
        }
    }

    public static void cancelAll(@NonNull Context context) {
        List<JobInfo> jobs;
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null && (jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler)) != null && !jobs.isEmpty()) {
            for (JobInfo jobInfo : jobs) {
                SystemJobScheduler.cancelJobById(jobScheduler, jobInfo.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reconcileJobs(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler);
        List<String> workManagerWorkSpecs = workManager.getWorkDatabase().systemIdInfoDao().getWorkSpecIds();
        int jobSize = jobs != null ? jobs.size() : 0;
        HashSet<String> jobSchedulerWorkSpecs = new HashSet<String>(jobSize);
        if (jobs != null && !jobs.isEmpty()) {
            for (JobInfo jobInfo : jobs) {
                String workSpecId = SystemJobScheduler.getWorkSpecIdFromJobInfo(jobInfo);
                if (!TextUtils.isEmpty((CharSequence)workSpecId)) {
                    jobSchedulerWorkSpecs.add(workSpecId);
                    continue;
                }
                SystemJobScheduler.cancelJobById(jobScheduler, jobInfo.getId());
            }
        }
        boolean needsReconciling = false;
        for (String workSpecId : workManagerWorkSpecs) {
            if (jobSchedulerWorkSpecs.contains(workSpecId)) continue;
            Logger.get().debug(TAG, "Reconciling jobs", new Throwable[0]);
            needsReconciling = true;
            break;
        }
        if (needsReconciling) {
            WorkDatabase workDatabase = workManager.getWorkDatabase();
            workDatabase.beginTransaction();
            try {
                WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                for (String workSpecId : workManagerWorkSpecs) {
                    workSpecDao.markWorkSpecScheduled(workSpecId, -1L);
                }
            }
            finally {
                workDatabase.endTransaction();
            }
        }
        return needsReconciling;
    }

    @Nullable
    private static List<JobInfo> getPendingJobs(@NonNull Context context, @NonNull JobScheduler jobScheduler) {
        List pendingJobs = null;
        try {
            pendingJobs = jobScheduler.getAllPendingJobs();
        }
        catch (Throwable exception) {
            Logger.get().error(TAG, "getAllPendingJobs() is not reliable on this device.", exception);
        }
        if (pendingJobs == null) {
            return null;
        }
        ArrayList<JobInfo> filtered = new ArrayList<JobInfo>(pendingJobs.size());
        ComponentName jobServiceComponent = new ComponentName(context, SystemJobService.class);
        for (JobInfo jobInfo : pendingJobs) {
            if (!jobServiceComponent.equals((Object)jobInfo.getService())) continue;
            filtered.add(jobInfo);
        }
        return filtered;
    }

    @Nullable
    private static List<Integer> getPendingJobIds(@NonNull Context context, @NonNull JobScheduler jobScheduler, @NonNull String workSpecId) {
        List<JobInfo> jobs = SystemJobScheduler.getPendingJobs(context, jobScheduler);
        if (jobs == null) {
            return null;
        }
        ArrayList<Integer> jobIds = new ArrayList<Integer>(2);
        for (JobInfo jobInfo : jobs) {
            if (!workSpecId.equals(SystemJobScheduler.getWorkSpecIdFromJobInfo(jobInfo))) continue;
            jobIds.add(jobInfo.getId());
        }
        return jobIds;
    }

    @Nullable
    private static String getWorkSpecIdFromJobInfo(@NonNull JobInfo jobInfo) {
        PersistableBundle extras = jobInfo.getExtras();
        try {
            if (extras != null && extras.containsKey("EXTRA_WORK_SPEC_ID")) {
                return extras.getString("EXTRA_WORK_SPEC_ID");
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }
}

