/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.impl.background.greedy.GreedyScheduler;
import java.lang.reflect.Method;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ProcessUtils {
    private static final String TAG = Logger.tagWithPrefix("ProcessUtils");

    private ProcessUtils() {
    }

    public static boolean isDefaultProcess(@NonNull Context context, @NonNull Configuration configuration) {
        String processName = ProcessUtils.getProcessName(context);
        if (!TextUtils.isEmpty((CharSequence)configuration.getDefaultProcessName())) {
            return TextUtils.equals((CharSequence)processName, (CharSequence)configuration.getDefaultProcessName());
        }
        ApplicationInfo info = context.getApplicationInfo();
        return TextUtils.equals((CharSequence)processName, (CharSequence)info.processName);
    }

    @Nullable
    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    public static String getProcessName(@NonNull Context context) {
        List processes;
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        try {
            Object packageName;
            Class<?> activityThread = Class.forName("android.app.ActivityThread", false, GreedyScheduler.class.getClassLoader());
            if (Build.VERSION.SDK_INT >= 18) {
                Method currentProcessName = activityThread.getDeclaredMethod("currentProcessName", new Class[0]);
                currentProcessName.setAccessible(true);
                packageName = currentProcessName.invoke(null, new Object[0]);
            } else {
                Method getActivityThread = activityThread.getDeclaredMethod("currentActivityThread", new Class[0]);
                getActivityThread.setAccessible(true);
                Method getProcessName = activityThread.getDeclaredMethod("getProcessName", new Class[0]);
                getProcessName.setAccessible(true);
                packageName = getProcessName.invoke(getActivityThread.invoke(null, new Object[0]), new Object[0]);
            }
            if (packageName instanceof String) {
                return (String)packageName;
            }
        }
        catch (Throwable exception) {
            Logger.get().debug(TAG, "Unable to check ActivityThread for processName", exception);
        }
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am != null && (processes = am.getRunningAppProcesses()) != null && !processes.isEmpty()) {
            for (ActivityManager.RunningAppProcessInfo process : processes) {
                if (process.pid != pid) continue;
                return process.processName;
            }
        }
        return null;
    }
}

