/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.net.Uri;
import android.os.Build;
import androidx.room.TypeConverter;
import androidx.work.BackoffPolicy;
import androidx.work.ContentUriTriggers;
import androidx.work.NetworkType;
import androidx.work.WorkInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class WorkTypeConverters {
    @TypeConverter
    public static int stateToInt(WorkInfo.State state) {
        switch (state) {
            case ENQUEUED: {
                return 0;
            }
            case RUNNING: {
                return 1;
            }
            case SUCCEEDED: {
                return 2;
            }
            case FAILED: {
                return 3;
            }
            case BLOCKED: {
                return 4;
            }
            case CANCELLED: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Could not convert " + (Object)((Object)state) + " to int");
    }

    @TypeConverter
    public static WorkInfo.State intToState(int value) {
        switch (value) {
            case 0: {
                return WorkInfo.State.ENQUEUED;
            }
            case 1: {
                return WorkInfo.State.RUNNING;
            }
            case 2: {
                return WorkInfo.State.SUCCEEDED;
            }
            case 3: {
                return WorkInfo.State.FAILED;
            }
            case 4: {
                return WorkInfo.State.BLOCKED;
            }
            case 5: {
                return WorkInfo.State.CANCELLED;
            }
        }
        throw new IllegalArgumentException("Could not convert " + value + " to State");
    }

    @TypeConverter
    public static int backoffPolicyToInt(BackoffPolicy backoffPolicy) {
        switch (backoffPolicy) {
            case EXPONENTIAL: {
                return 0;
            }
            case LINEAR: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Could not convert " + (Object)((Object)backoffPolicy) + " to int");
    }

    @TypeConverter
    public static BackoffPolicy intToBackoffPolicy(int value) {
        switch (value) {
            case 0: {
                return BackoffPolicy.EXPONENTIAL;
            }
            case 1: {
                return BackoffPolicy.LINEAR;
            }
        }
        throw new IllegalArgumentException("Could not convert " + value + " to BackoffPolicy");
    }

    @TypeConverter
    public static int networkTypeToInt(NetworkType networkType) {
        switch (networkType) {
            case NOT_REQUIRED: {
                return 0;
            }
            case CONNECTED: {
                return 1;
            }
            case UNMETERED: {
                return 2;
            }
            case NOT_ROAMING: {
                return 3;
            }
            case METERED: {
                return 4;
            }
        }
        if (Build.VERSION.SDK_INT >= 30 && networkType == NetworkType.TEMPORARILY_UNMETERED) {
            return 5;
        }
        throw new IllegalArgumentException("Could not convert " + (Object)((Object)networkType) + " to int");
    }

    @TypeConverter
    public static NetworkType intToNetworkType(int value) {
        switch (value) {
            case 0: {
                return NetworkType.NOT_REQUIRED;
            }
            case 1: {
                return NetworkType.CONNECTED;
            }
            case 2: {
                return NetworkType.UNMETERED;
            }
            case 3: {
                return NetworkType.NOT_ROAMING;
            }
            case 4: {
                return NetworkType.METERED;
            }
        }
        if (Build.VERSION.SDK_INT >= 30 && value == 5) {
            return NetworkType.TEMPORARILY_UNMETERED;
        }
        throw new IllegalArgumentException("Could not convert " + value + " to NetworkType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TypeConverter
    public static byte[] contentUriTriggersToByteArray(ContentUriTriggers triggers) {
        if (triggers.size() == 0) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeInt(triggers.size());
            for (ContentUriTriggers.Trigger trigger : triggers.getTriggers()) {
                objectOutputStream.writeUTF(trigger.getUri().toString());
                objectOutputStream.writeBoolean(trigger.shouldTriggerForDescendants());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TypeConverter
    public static ContentUriTriggers byteArrayToContentUriTriggers(byte[] bytes) {
        ContentUriTriggers triggers = new ContentUriTriggers();
        if (bytes == null) {
            return triggers;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            for (int i = objectInputStream.readInt(); i > 0; --i) {
                Uri uri = Uri.parse((String)objectInputStream.readUTF());
                boolean triggersForDescendants = objectInputStream.readBoolean();
                triggers.add(uri, triggersForDescendants);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return triggers;
    }

    private WorkTypeConverters() {
    }

    public static interface NetworkTypeIds {
        public static final int NOT_REQUIRED = 0;
        public static final int CONNECTED = 1;
        public static final int UNMETERED = 2;
        public static final int NOT_ROAMING = 3;
        public static final int METERED = 4;
        public static final int TEMPORARILY_UNMETERED = 5;
    }

    public static interface BackoffPolicyIds {
        public static final int EXPONENTIAL = 0;
        public static final int LINEAR = 1;
    }

    public static interface StateIds {
        public static final int ENQUEUED = 0;
        public static final int RUNNING = 1;
        public static final int SUCCEEDED = 2;
        public static final int FAILED = 3;
        public static final int BLOCKED = 4;
        public static final int CANCELLED = 5;
        public static final String COMPLETED_STATES = "(2, 3, 5)";
    }
}

