/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkContinuation;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.multiprocess.RemoteWorkContinuation;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public abstract class RemoteWorkManager {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected RemoteWorkManager() {
    }

    @NonNull
    public abstract ListenableFuture<Void> enqueue(@NonNull WorkRequest var1);

    @NonNull
    public abstract ListenableFuture<Void> enqueue(@NonNull List<WorkRequest> var1);

    @NonNull
    public final ListenableFuture<Void> enqueueUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull OneTimeWorkRequest work) {
        return this.enqueueUniqueWork(uniqueWorkName, existingWorkPolicy, Collections.singletonList(work));
    }

    @NonNull
    public abstract ListenableFuture<Void> enqueueUniqueWork(@NonNull String var1, @NonNull ExistingWorkPolicy var2, @NonNull List<OneTimeWorkRequest> var3);

    @NonNull
    public abstract ListenableFuture<Void> enqueueUniquePeriodicWork(@NonNull String var1, @NonNull ExistingPeriodicWorkPolicy var2, @NonNull PeriodicWorkRequest var3);

    @NonNull
    public final RemoteWorkContinuation beginWith(@NonNull OneTimeWorkRequest work) {
        return this.beginWith(Collections.singletonList(work));
    }

    @NonNull
    public abstract RemoteWorkContinuation beginWith(@NonNull List<OneTimeWorkRequest> var1);

    @NonNull
    public final RemoteWorkContinuation beginUniqueWork(@NonNull String uniqueWorkName, @NonNull ExistingWorkPolicy existingWorkPolicy, @NonNull OneTimeWorkRequest work) {
        return this.beginUniqueWork(uniqueWorkName, existingWorkPolicy, Collections.singletonList(work));
    }

    @NonNull
    public abstract RemoteWorkContinuation beginUniqueWork(@NonNull String var1, @NonNull ExistingWorkPolicy var2, @NonNull List<OneTimeWorkRequest> var3);

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public abstract ListenableFuture<Void> enqueue(@NonNull WorkContinuation var1);

    @NonNull
    public abstract ListenableFuture<Void> cancelWorkById(@NonNull UUID var1);

    @NonNull
    public abstract ListenableFuture<Void> cancelAllWorkByTag(@NonNull String var1);

    @NonNull
    public abstract ListenableFuture<Void> cancelUniqueWork(@NonNull String var1);

    @NonNull
    public abstract ListenableFuture<Void> cancelAllWork();

    @NonNull
    public abstract ListenableFuture<List<WorkInfo>> getWorkInfos(@NonNull WorkQuery var1);

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public abstract ListenableFuture<Void> setProgress(@NonNull UUID var1, @NonNull Data var2);

    @NonNull
    public static RemoteWorkManager getInstance(@NonNull Context context) {
        WorkManagerImpl workManager = WorkManagerImpl.getInstance(context);
        RemoteWorkManager remoteWorkManager = workManager.getRemoteWorkManager();
        if (remoteWorkManager == null) {
            throw new IllegalStateException("Unable to initialize RemoteWorkManager");
        }
        return remoteWorkManager;
    }
}

