/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.core.net.ConnectivityManagerCompat;
import androidx.work.Logger;
import androidx.work.impl.constraints.NetworkState;
import androidx.work.impl.constraints.trackers.ConstraintTracker;
import androidx.work.impl.constraints.trackers.NetworkStateTracker24;
import androidx.work.impl.constraints.trackers.NetworkStateTrackerPre24;
import androidx.work.impl.utils.NetworkApi21;
import androidx.work.impl.utils.NetworkApi23;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0012"}, d2={"TAG", "", "activeNetworkState", "Landroidx/work/impl/constraints/NetworkState;", "Landroid/net/ConnectivityManager;", "getActiveNetworkState$annotations", "(Landroid/net/ConnectivityManager;)V", "getActiveNetworkState", "(Landroid/net/ConnectivityManager;)Landroidx/work/impl/constraints/NetworkState;", "isActiveNetworkValidated", "", "(Landroid/net/ConnectivityManager;)Z", "NetworkStateTracker", "Landroidx/work/impl/constraints/trackers/ConstraintTracker;", "context", "Landroid/content/Context;", "taskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "work-runtime_release"})
public final class NetworkStateTrackerKt {
    @NotNull
    private static final String TAG;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ConstraintTracker<NetworkState> NetworkStateTracker(@NotNull Context context, @NotNull TaskExecutor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        return Build.VERSION.SDK_INT >= 24 ? (ConstraintTracker)new NetworkStateTracker24(context, taskExecutor) : (ConstraintTracker)new NetworkStateTrackerPre24(context, taskExecutor);
    }

    public static final boolean isActiveNetworkValidated(@NotNull ConnectivityManager $this$isActiveNetworkValidated) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isActiveNetworkValidated, (String)"<this>");
        if (Build.VERSION.SDK_INT < 23) {
            bl = false;
        } else {
            boolean bl2;
            try {
                boolean bl3;
                NetworkCapabilities capabilities;
                Network network = NetworkApi23.getActiveNetworkCompat($this$isActiveNetworkValidated);
                NetworkCapabilities networkCapabilities = capabilities = NetworkApi21.getNetworkCapabilitiesCompat($this$isActiveNetworkValidated, network);
                bl2 = networkCapabilities == null ? false : (bl3 = NetworkApi21.hasCapabilityCompat(networkCapabilities, 16));
            }
            catch (SecurityException exception) {
                Logger.get().error(TAG, "Unable to validate active network", exception);
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @NotNull
    public static final NetworkState getActiveNetworkState(@NotNull ConnectivityManager $this$activeNetworkState) {
        Intrinsics.checkNotNullParameter((Object)$this$activeNetworkState, (String)"<this>");
        NetworkInfo info = $this$activeNetworkState.getActiveNetworkInfo();
        boolean isConnected = info != null && info.isConnected();
        boolean isValidated = NetworkStateTrackerKt.isActiveNetworkValidated($this$activeNetworkState);
        boolean isMetered = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)$this$activeNetworkState);
        boolean isNotRoaming = info != null && !info.isRoaming();
        return new NetworkState(isConnected, isValidated, isMetered, isNotRoaming);
    }

    public static /* synthetic */ void getActiveNetworkState$annotations(ConnectivityManager connectivityManager) {
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    static {
        String string = Logger.tagWithPrefix("NetworkStateTracker");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"NetworkStateTracker\")");
        TAG = string;
    }
}

