/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.work.Configuration;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkerWrapper;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.foreground.SystemForegroundDispatcher;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Processor
implements ExecutionListener,
ForegroundProcessor {
    private static final String TAG = Logger.tagWithPrefix("Processor");
    private static final String FOREGROUND_WAKELOCK_TAG = "ProcessorForegroundLck";
    @Nullable
    private PowerManager.WakeLock mForegroundLock;
    private Context mAppContext;
    private Configuration mConfiguration;
    private TaskExecutor mWorkTaskExecutor;
    private WorkDatabase mWorkDatabase;
    private Map<String, WorkerWrapper> mForegroundWorkMap;
    private Map<String, WorkerWrapper> mEnqueuedWorkMap;
    private Map<String, Set<StartStopToken>> mWorkRuns;
    private List<Scheduler> mSchedulers;
    private Set<String> mCancelledIds;
    private final List<ExecutionListener> mOuterListeners;
    private final Object mLock;

    public Processor(@NonNull Context appContext, @NonNull Configuration configuration, @NonNull TaskExecutor workTaskExecutor, @NonNull WorkDatabase workDatabase, @NonNull List<Scheduler> schedulers) {
        this.mAppContext = appContext;
        this.mConfiguration = configuration;
        this.mWorkTaskExecutor = workTaskExecutor;
        this.mWorkDatabase = workDatabase;
        this.mEnqueuedWorkMap = new HashMap<String, WorkerWrapper>();
        this.mForegroundWorkMap = new HashMap<String, WorkerWrapper>();
        this.mSchedulers = schedulers;
        this.mCancelledIds = new HashSet<String>();
        this.mOuterListeners = new ArrayList<ExecutionListener>();
        this.mForegroundLock = null;
        this.mLock = new Object();
        this.mWorkRuns = new HashMap<String, Set<StartStopToken>>();
    }

    public boolean startWork(@NonNull StartStopToken id) {
        return this.startWork(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWork(@NonNull StartStopToken startStopToken, @Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
        WorkerWrapper workWrapper;
        ArrayList<String> tags = new ArrayList<String>();
        WorkGenerationalId id = startStopToken.getId();
        String workSpecId = id.getWorkSpecId();
        WorkSpec workSpec = (WorkSpec)this.mWorkDatabase.runInTransaction(() -> {
            tags.addAll(this.mWorkDatabase.workTagDao().getTagsForWorkSpecId(workSpecId));
            return this.mWorkDatabase.workSpecDao().getWorkSpec(workSpecId);
        });
        if (workSpec == null) {
            Logger.get().warning(TAG, "Didn't find WorkSpec for id " + id);
            this.runOnExecuted(id, false);
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isEnqueued(workSpecId)) {
                Set<StartStopToken> tokens = this.mWorkRuns.get(workSpecId);
                StartStopToken previousRun = tokens.iterator().next();
                int previousRunGeneration = previousRun.getId().getGeneration();
                if (previousRunGeneration == id.getGeneration()) {
                    tokens.add(startStopToken);
                    Logger.get().debug(TAG, "Work " + id + " is already enqueued for processing");
                } else {
                    this.runOnExecuted(id, false);
                }
                return false;
            }
            if (workSpec.getGeneration() != id.getGeneration()) {
                this.runOnExecuted(id, false);
                return false;
            }
            workWrapper = new WorkerWrapper.Builder(this.mAppContext, this.mConfiguration, this.mWorkTaskExecutor, this, this.mWorkDatabase, workSpec, tags).withSchedulers(this.mSchedulers).withRuntimeExtras(runtimeExtras).build();
            ListenableFuture<Boolean> future = workWrapper.getFuture();
            future.addListener((Runnable)new FutureListener(this, startStopToken.getId(), future), this.mWorkTaskExecutor.getMainThreadExecutor());
            this.mEnqueuedWorkMap.put(workSpecId, workWrapper);
            HashSet<StartStopToken> set = new HashSet<StartStopToken>();
            set.add(startStopToken);
            this.mWorkRuns.put(workSpecId, set);
        }
        this.mWorkTaskExecutor.getSerialTaskExecutor().execute(workWrapper);
        Logger.get().debug(TAG, this.getClass().getSimpleName() + ": processing " + id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startForeground(@NonNull String workSpecId, @NonNull ForegroundInfo foregroundInfo) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().info(TAG, "Moving WorkSpec (" + workSpecId + ") to the foreground");
            WorkerWrapper wrapper = this.mEnqueuedWorkMap.remove(workSpecId);
            if (wrapper != null) {
                if (this.mForegroundLock == null) {
                    this.mForegroundLock = WakeLocks.newWakeLock(this.mAppContext, FOREGROUND_WAKELOCK_TAG);
                    this.mForegroundLock.acquire();
                }
                this.mForegroundWorkMap.put(workSpecId, wrapper);
                Intent intent = SystemForegroundDispatcher.createStartForegroundIntent(this.mAppContext, wrapper.getWorkGenerationalId(), foregroundInfo);
                ContextCompat.startForegroundService((Context)this.mAppContext, (Intent)intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopForegroundWork(@NonNull StartStopToken token) {
        String id = token.getId().getWorkSpecId();
        WorkerWrapper wrapper = null;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor stopping foreground work " + id);
            wrapper = this.mForegroundWorkMap.remove(id);
            if (wrapper != null) {
                this.mWorkRuns.remove(id);
            }
        }
        return Processor.interrupt(id, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopWork(@NonNull StartStopToken runId) {
        String id = runId.getId().getWorkSpecId();
        WorkerWrapper wrapper = null;
        Object object = this.mLock;
        synchronized (object) {
            wrapper = this.mEnqueuedWorkMap.remove(id);
            if (wrapper == null) {
                Logger.get().debug(TAG, "WorkerWrapper could not be found for " + id);
                return false;
            }
            Set<StartStopToken> runs = this.mWorkRuns.get(id);
            if (runs == null || !runs.contains(runId)) {
                return false;
            }
            Logger.get().debug(TAG, "Processor stopping background work " + id);
            this.mWorkRuns.remove(id);
        }
        return Processor.interrupt(id, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndCancelWork(@NonNull String id) {
        WorkerWrapper wrapper = null;
        boolean isForegroundWork = false;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor cancelling " + id);
            this.mCancelledIds.add(id);
            wrapper = this.mForegroundWorkMap.remove(id);
            boolean bl = isForegroundWork = wrapper != null;
            if (wrapper == null) {
                wrapper = this.mEnqueuedWorkMap.remove(id);
            }
            if (wrapper != null) {
                this.mWorkRuns.remove(id);
            }
        }
        boolean interrupted = Processor.interrupt(id, wrapper);
        if (isForegroundWork) {
            this.stopForegroundService();
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopForeground(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mForegroundWorkMap.remove(workSpecId);
            this.stopForegroundService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled(@NonNull String id) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCancelledIds.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWork() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mEnqueuedWorkMap.isEmpty() || !this.mForegroundWorkMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnqueuedWorkMap.containsKey(workSpecId) || this.mForegroundWorkMap.containsKey(workSpecId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnqueuedInForeground(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mForegroundWorkMap.containsKey(workSpecId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.add(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.remove(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        Object object = this.mLock;
        synchronized (object) {
            WorkerWrapper workerWrapper = this.mEnqueuedWorkMap.get(id.getWorkSpecId());
            if (workerWrapper != null && id.equals(workerWrapper.getWorkGenerationalId())) {
                this.mEnqueuedWorkMap.remove(id.getWorkSpecId());
            }
            Logger.get().debug(TAG, this.getClass().getSimpleName() + " " + id.getWorkSpecId() + " executed; reschedule = " + needsReschedule);
            for (ExecutionListener executionListener : this.mOuterListeners) {
                executionListener.onExecuted(id, needsReschedule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkSpec getRunningWorkSpec(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            WorkerWrapper workerWrapper = this.mForegroundWorkMap.get(workSpecId);
            if (workerWrapper == null) {
                workerWrapper = this.mEnqueuedWorkMap.get(workSpecId);
            }
            if (workerWrapper != null) {
                return workerWrapper.getWorkSpec();
            }
            return null;
        }
    }

    private void runOnExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        this.mWorkTaskExecutor.getMainThreadExecutor().execute(() -> this.onExecuted(id, needsReschedule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopForegroundService() {
        Object object = this.mLock;
        synchronized (object) {
            boolean hasForegroundWork;
            boolean bl = hasForegroundWork = !this.mForegroundWorkMap.isEmpty();
            if (!hasForegroundWork) {
                Intent intent = SystemForegroundDispatcher.createStopForegroundIntent(this.mAppContext);
                try {
                    this.mAppContext.startService(intent);
                }
                catch (Throwable throwable) {
                    Logger.get().error(TAG, "Unable to stop foreground service", throwable);
                }
                if (this.mForegroundLock != null) {
                    this.mForegroundLock.release();
                    this.mForegroundLock = null;
                }
            }
        }
    }

    private static boolean interrupt(@NonNull String id, @Nullable WorkerWrapper wrapper) {
        if (wrapper != null) {
            wrapper.interrupt();
            Logger.get().debug(TAG, "WorkerWrapper interrupted for " + id);
            return true;
        }
        Logger.get().debug(TAG, "WorkerWrapper could not be found for " + id);
        return false;
    }

    private static class FutureListener
    implements Runnable {
        @NonNull
        private ExecutionListener mExecutionListener;
        @NonNull
        private final WorkGenerationalId mWorkGenerationalId;
        @NonNull
        private ListenableFuture<Boolean> mFuture;

        FutureListener(@NonNull ExecutionListener executionListener, @NonNull WorkGenerationalId workGenerationalId, @NonNull ListenableFuture<Boolean> future) {
            this.mExecutionListener = executionListener;
            this.mWorkGenerationalId = workGenerationalId;
            this.mFuture = future;
        }

        @Override
        public void run() {
            boolean needsReschedule;
            try {
                needsReschedule = (Boolean)this.mFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                needsReschedule = true;
            }
            this.mExecutionListener.onExecuted(this.mWorkGenerationalId, needsReschedule);
        }
    }
}

