/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.greedy;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.RunnableScheduler;
import androidx.work.WorkInfo;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Processor;
import androidx.work.impl.Scheduler;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.StartStopTokens;
import androidx.work.impl.WorkLauncher;
import androidx.work.impl.background.greedy.DelayedWorkTracker;
import androidx.work.impl.background.greedy.TimeLimiter;
import androidx.work.impl.constraints.ConstraintsState;
import androidx.work.impl.constraints.OnConstraintsStateChangedListener;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerKt;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.ProcessUtils;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlinx.coroutines.Job;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GreedyScheduler
implements Scheduler,
OnConstraintsStateChangedListener,
ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("GreedyScheduler");
    private static final int NON_THROTTLE_RUN_ATTEMPT_COUNT = 5;
    private final Context mContext;
    private final Map<WorkGenerationalId, Job> mConstrainedWorkSpecs = new HashMap<WorkGenerationalId, Job>();
    private DelayedWorkTracker mDelayedWorkTracker;
    private boolean mRegisteredExecutionListener;
    private final Object mLock = new Object();
    private final StartStopTokens mStartStopTokens = new StartStopTokens();
    private final Processor mProcessor;
    private final WorkLauncher mWorkLauncher;
    private final Configuration mConfiguration;
    private final Map<WorkGenerationalId, AttemptData> mFirstRunAttempts = new HashMap<WorkGenerationalId, AttemptData>();
    Boolean mInDefaultProcess;
    private final WorkConstraintsTracker mConstraintsTracker;
    private final TaskExecutor mTaskExecutor;
    private final TimeLimiter mTimeLimiter;

    public GreedyScheduler(@NonNull Context context, @NonNull Configuration configuration, @NonNull Trackers trackers, @NonNull Processor processor, @NonNull WorkLauncher workLauncher, @NonNull TaskExecutor taskExecutor) {
        this.mContext = context;
        RunnableScheduler runnableScheduler = configuration.getRunnableScheduler();
        this.mDelayedWorkTracker = new DelayedWorkTracker(this, runnableScheduler, configuration.getClock());
        this.mTimeLimiter = new TimeLimiter(runnableScheduler, workLauncher);
        this.mTaskExecutor = taskExecutor;
        this.mConstraintsTracker = new WorkConstraintsTracker(trackers);
        this.mConfiguration = configuration;
        this.mProcessor = processor;
        this.mWorkLauncher = workLauncher;
    }

    @VisibleForTesting
    public void setDelayedWorkTracker(@NonNull DelayedWorkTracker delayedWorkTracker) {
        this.mDelayedWorkTracker = delayedWorkTracker;
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(WorkSpec ... workSpecs) {
        WorkGenerationalId id;
        if (this.mInDefaultProcess == null) {
            this.checkDefaultProcess();
        }
        if (!this.mInDefaultProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in a secondary process");
            return;
        }
        this.registerExecutionListenerIfNeeded();
        HashSet<WorkSpec> constrainedWorkSpecs = new HashSet<WorkSpec>();
        HashSet<String> constrainedWorkSpecIds = new HashSet<String>();
        for (WorkSpec workSpec : workSpecs) {
            id = WorkSpecKt.generationalId(workSpec);
            if (this.mStartStopTokens.contains(id)) continue;
            long throttled = this.throttleIfNeeded(workSpec);
            long nextRunTime = Math.max(workSpec.calculateNextRunTime(), throttled);
            long now = this.mConfiguration.getClock().currentTimeMillis();
            if (workSpec.state != WorkInfo.State.ENQUEUED) continue;
            if (now < nextRunTime) {
                if (this.mDelayedWorkTracker == null) continue;
                this.mDelayedWorkTracker.schedule(workSpec, nextRunTime);
                continue;
            }
            if (workSpec.hasConstraints()) {
                if (Build.VERSION.SDK_INT >= 23 && workSpec.constraints.requiresDeviceIdle()) {
                    Logger.get().debug(TAG, "Ignoring " + workSpec + ". Requires device idle.");
                    continue;
                }
                if (Build.VERSION.SDK_INT >= 24 && workSpec.constraints.hasContentUriTriggers()) {
                    Logger.get().debug(TAG, "Ignoring " + workSpec + ". Requires ContentUri triggers.");
                    continue;
                }
                constrainedWorkSpecs.add(workSpec);
                constrainedWorkSpecIds.add(workSpec.id);
                continue;
            }
            if (this.mStartStopTokens.contains(WorkSpecKt.generationalId(workSpec))) continue;
            Logger.get().debug(TAG, "Starting work for " + workSpec.id);
            StartStopToken token = this.mStartStopTokens.tokenFor(workSpec);
            this.mTimeLimiter.track(token);
            this.mWorkLauncher.startWork(token);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!constrainedWorkSpecs.isEmpty()) {
                String formattedIds = TextUtils.join((CharSequence)",", constrainedWorkSpecIds);
                Logger.get().debug(TAG, "Starting tracking for " + formattedIds);
                for (WorkSpec spec : constrainedWorkSpecs) {
                    id = WorkSpecKt.generationalId(spec);
                    if (this.mConstrainedWorkSpecs.containsKey(id)) continue;
                    Job job = WorkConstraintsTrackerKt.listen(this.mConstraintsTracker, spec, this.mTaskExecutor.getTaskCoroutineDispatcher(), this);
                    this.mConstrainedWorkSpecs.put(id, job);
                }
            }
        }
    }

    private void checkDefaultProcess() {
        this.mInDefaultProcess = ProcessUtils.isDefaultProcess(this.mContext, this.mConfiguration);
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        if (this.mInDefaultProcess == null) {
            this.checkDefaultProcess();
        }
        if (!this.mInDefaultProcess.booleanValue()) {
            Logger.get().info(TAG, "Ignoring schedule request in non-main process");
            return;
        }
        this.registerExecutionListenerIfNeeded();
        Logger.get().debug(TAG, "Cancelling work ID " + workSpecId);
        if (this.mDelayedWorkTracker != null) {
            this.mDelayedWorkTracker.unschedule(workSpecId);
        }
        for (StartStopToken id : this.mStartStopTokens.remove(workSpecId)) {
            this.mTimeLimiter.cancel(id);
            this.mWorkLauncher.stopWork(id);
        }
    }

    @Override
    public void onConstraintsStateChanged(@NonNull WorkSpec workSpec, @NonNull ConstraintsState state) {
        WorkGenerationalId id = WorkSpecKt.generationalId(workSpec);
        if (state instanceof ConstraintsState.ConstraintsMet) {
            if (!this.mStartStopTokens.contains(id)) {
                Logger.get().debug(TAG, "Constraints met: Scheduling work ID " + id);
                StartStopToken token = this.mStartStopTokens.tokenFor(id);
                this.mTimeLimiter.track(token);
                this.mWorkLauncher.startWork(token);
            }
        } else {
            Logger.get().debug(TAG, "Constraints not met: Cancelling work ID " + id);
            StartStopToken runId = this.mStartStopTokens.remove(id);
            if (runId != null) {
                this.mTimeLimiter.cancel(runId);
                int reason = ((ConstraintsState.ConstraintsNotMet)state).getReason();
                this.mWorkLauncher.stopWorkWithReason(runId, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        StartStopToken token = this.mStartStopTokens.remove(id);
        if (token != null) {
            this.mTimeLimiter.cancel(token);
        }
        this.removeConstraintTrackingFor(id);
        if (!needsReschedule) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFirstRunAttempts.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstraintTrackingFor(@NonNull WorkGenerationalId id) {
        Job job;
        Object object = this.mLock;
        synchronized (object) {
            job = this.mConstrainedWorkSpecs.remove(id);
        }
        if (job != null) {
            Logger.get().debug(TAG, "Stopping tracking for " + id);
            job.cancel(null);
        }
    }

    private void registerExecutionListenerIfNeeded() {
        if (!this.mRegisteredExecutionListener) {
            this.mProcessor.addExecutionListener(this);
            this.mRegisteredExecutionListener = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long throttleIfNeeded(WorkSpec workSpec) {
        Object object = this.mLock;
        synchronized (object) {
            WorkGenerationalId id = WorkSpecKt.generationalId(workSpec);
            AttemptData firstRunAttempt = this.mFirstRunAttempts.get(id);
            if (firstRunAttempt == null) {
                firstRunAttempt = new AttemptData(workSpec.runAttemptCount, this.mConfiguration.getClock().currentTimeMillis());
                this.mFirstRunAttempts.put(id, firstRunAttempt);
            }
            return firstRunAttempt.mTimeStamp + (long)Math.max(workSpec.runAttemptCount - firstRunAttempt.mRunAttemptCount - 5, 0) * 30000L;
        }
    }

    private static class AttemptData {
        final int mRunAttemptCount;
        final long mTimeStamp;

        private AttemptData(int runAttemptCount, long timeStamp) {
            this.mRunAttemptCount = runAttemptCount;
            this.mTimeStamp = timeStamp;
        }
    }
}

