/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public abstract class RxWorker
extends ListenableWorker {
    static final Executor INSTANT_EXECUTOR = new SynchronousExecutor();
    @Nullable
    private SingleFutureAdapter<ListenableWorker.Result> mSingleFutureObserverAdapter;

    public RxWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
    }

    @NonNull
    public ListenableFuture<ListenableWorker.Result> startWork() {
        this.mSingleFutureObserverAdapter = new SingleFutureAdapter();
        Scheduler scheduler = this.getBackgroundScheduler();
        this.createWork().subscribeOn(scheduler).observeOn(Schedulers.from((Executor)this.getTaskExecutor().getBackgroundExecutor())).subscribe(this.mSingleFutureObserverAdapter);
        return this.mSingleFutureObserverAdapter.mFuture;
    }

    @NonNull
    protected Scheduler getBackgroundScheduler() {
        return Schedulers.from((Executor)this.getBackgroundExecutor());
    }

    @MainThread
    @NonNull
    public abstract Single<ListenableWorker.Result> createWork();

    @NonNull
    public final Single<Void> setProgress(@NonNull Data data) {
        return Single.fromFuture((Future)this.setProgressAsync(data));
    }

    public void onStopped() {
        super.onStopped();
        SingleFutureAdapter<ListenableWorker.Result> observer = this.mSingleFutureObserverAdapter;
        if (observer != null) {
            observer.dispose();
            this.mSingleFutureObserverAdapter = null;
        }
    }

    static class SingleFutureAdapter<T>
    implements SingleObserver<T>,
    Runnable {
        final SettableFuture<T> mFuture = SettableFuture.create();
        @Nullable
        private Disposable mDisposable;

        SingleFutureAdapter() {
            this.mFuture.addListener((Runnable)this, INSTANT_EXECUTOR);
        }

        public void onSubscribe(Disposable disposable) {
            this.mDisposable = disposable;
        }

        public void onSuccess(T t) {
            this.mFuture.set(t);
        }

        public void onError(Throwable throwable) {
            this.mFuture.setException(throwable);
        }

        @Override
        public void run() {
            if (this.mFuture.isCancelled()) {
                this.dispose();
            }
        }

        void dispose() {
            Disposable disposable = this.mDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }
}

