/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.Data;
import androidx.work.ForegroundInfo;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.SynchronousExecutor;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public abstract class RxWorker
extends ListenableWorker {
    static final Executor INSTANT_EXECUTOR = new SynchronousExecutor();
    @Nullable
    private SingleFutureAdapter<ListenableWorker.Result> mSingleFutureObserverAdapter;

    public RxWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
    }

    @NonNull
    public ListenableFuture<ListenableWorker.Result> startWork() {
        this.mSingleFutureObserverAdapter = new SingleFutureAdapter();
        return this.convert(this.mSingleFutureObserverAdapter, this.createWork());
    }

    @NonNull
    protected Scheduler getBackgroundScheduler() {
        return Schedulers.from((Executor)this.getBackgroundExecutor());
    }

    @MainThread
    @NonNull
    public abstract Single<ListenableWorker.Result> createWork();

    @Deprecated
    @NonNull
    public final Single<Void> setProgress(@NonNull Data data) {
        return Single.fromFuture((Future)this.setProgressAsync(data));
    }

    @NonNull
    public final Completable setCompletableProgress(@NonNull Data data) {
        return Completable.fromFuture((Future)this.setProgressAsync(data));
    }

    public void onStopped() {
        super.onStopped();
        SingleFutureAdapter<ListenableWorker.Result> observer = this.mSingleFutureObserverAdapter;
        if (observer != null) {
            observer.dispose();
            this.mSingleFutureObserverAdapter = null;
        }
    }

    @NonNull
    public ListenableFuture<ForegroundInfo> getForegroundInfoAsync() {
        return this.convert(new SingleFutureAdapter(), this.getForegroundInfo());
    }

    @NonNull
    public Single<ForegroundInfo> getForegroundInfo() {
        String message = "Expedited WorkRequests require a RxWorker to provide an implementation for `getForegroundInfo()`";
        return Single.error((Throwable)new IllegalStateException(message));
    }

    @NonNull
    public final Completable setForeground(@NonNull ForegroundInfo foregroundInfo) {
        return Completable.fromFuture((Future)this.setForegroundAsync(foregroundInfo));
    }

    private <T> ListenableFuture<T> convert(SingleFutureAdapter<T> adapter, Single<T> single) {
        Scheduler scheduler = this.getBackgroundScheduler();
        single.subscribeOn(scheduler).observeOn(Schedulers.from((Executor)this.getTaskExecutor().getSerialTaskExecutor())).subscribe(adapter);
        return adapter.mFuture;
    }

    static class SingleFutureAdapter<T>
    implements SingleObserver<T>,
    Runnable {
        final SettableFuture<T> mFuture = SettableFuture.create();
        @Nullable
        private Disposable mDisposable;

        SingleFutureAdapter() {
            this.mFuture.addListener((Runnable)this, INSTANT_EXECUTOR);
        }

        public void onSubscribe(Disposable disposable) {
            this.mDisposable = disposable;
        }

        public void onSuccess(T t) {
            this.mFuture.set(t);
        }

        public void onError(Throwable throwable) {
            this.mFuture.setException(throwable);
        }

        @Override
        public void run() {
            if (this.mFuture.isCancelled()) {
                this.dispose();
            }
        }

        void dispose() {
            Disposable disposable = this.mDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
        }
    }
}

