/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.MonitorRandomAccessContent;
import org.apache.commons.vfs.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    private static final int STATE_NONE = 0;
    private static final int STATE_READING = 1;
    private static final int STATE_WRITING = 2;
    private static final int STATE_RANDOM_ACCESS = 3;
    private final AbstractFileObject file;
    private int state = 0;
    private final ArrayList instrs = new ArrayList();
    private FileContentOutputStream outstr;
    private Map attrs;
    private Map roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private RandomAccessContent rastr;

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.file = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public FileObject getFile() {
        return this.file;
    }

    public long getSize() throws FileSystemException {
        if (!this.file.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.file);
        }
        if (this.state == 2 || this.state == 3) {
            throw new FileSystemException("vfs.provider/get-size-write.error", this.file);
        }
        try {
            return this.file.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.file}, (Throwable)exc);
        }
    }

    public long getLastModifiedTime() throws FileSystemException {
        if (this.state == 2 || this.state == 3) {
            throw new FileSystemException("vfs.provider/get-last-modified-writing.error", this.file);
        }
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.file);
        }
        try {
            return this.file.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.file, (Throwable)e);
        }
    }

    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (this.state == 2 || this.state == 3) {
            throw new FileSystemException("vfs.provider/set-last-modified-writing.error", this.file);
        }
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.file);
        }
        try {
            this.file.doSetLastModifiedTime(modTime);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.file, (Throwable)e);
        }
    }

    public Map getAttributes() throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.file);
        }
        if (this.roAttrs == null) {
            try {
                this.attrs = this.file.doGetAttributes();
                this.roAttrs = Collections.unmodifiableMap(this.attrs);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.file, (Throwable)e);
            }
        }
        return this.roAttrs;
    }

    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set names = this.attrs.keySet();
        return names.toArray(new String[names.size()]);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(attrName.toLowerCase());
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (!this.file.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{attrName, this.file});
        }
        try {
            this.file.doSetAttribute(attrName, value);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{attrName, this.file}, (Throwable)e);
        }
        if (this.attrs != null) {
            this.attrs.put(attrName, value);
        }
    }

    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.file.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.file);
        }
        if (this.state == 2 || this.state == 3) {
            throw new FileSystemException("vfs.provider/get-certificates-writing.error", this.file);
        }
        try {
            Certificate[] certs = this.file.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.file, (Throwable)e);
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        if (this.state == 2 || this.state == 3) {
            throw new FileSystemException("vfs.provider/read-in-use.error", this.file);
        }
        InputStream instr = this.file.getInputStream();
        FileContentInputStream wrappedInstr = new FileContentInputStream(instr);
        this.instrs.add(wrappedInstr);
        this.state = 1;
        return wrappedInstr;
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        if (this.state != 0) {
            throw new FileSystemException("vfs.provider/read-in-use.error", this.file);
        }
        RandomAccessContent rastr = this.file.getRandomAccessContent(mode);
        this.rastr = new FileRandomAccessContent(rastr);
        this.state = 3;
        return this.rastr;
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        if (this.state != 0) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.file);
        }
        OutputStream outstr = this.file.getOutputStream(bAppend);
        this.outstr = new FileContentOutputStream(outstr);
        this.state = 2;
        return this.outstr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FileSystemException {
        block7: {
            try {
                while (this.instrs.size() > 0) {
                    FileContentInputStream instr = (FileContentInputStream)this.instrs.remove(0);
                    instr.close();
                }
                if (this.outstr != null) {
                    this.outstr.close();
                }
                if (this.rastr == null) break block7;
                try {
                    this.rastr.close();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            finally {
                this.state = 0;
            }
        }
    }

    private void endInput(FileContentInputStream instr) {
        this.instrs.remove(instr);
        if (this.instrs.size() == 0) {
            this.state = 0;
        }
    }

    private void endRandomAccess() {
        this.state = 0;
    }

    private void endOutput() throws Exception {
        this.outstr = null;
        this.state = 0;
        this.file.endOutput();
    }

    public boolean isOpen() {
        return this.state != 0;
    }

    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    private final class FileContentOutputStream
    extends MonitorOutputStream {
        FileContentOutputStream(OutputStream outstr) {
            super(outstr);
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }

        protected void onClose() throws IOException {
            try {
                DefaultFileContent.this.endOutput();
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        FileRandomAccessContent(RandomAccessContent content) {
            super(content);
        }

        protected void onClose() throws IOException {
            DefaultFileContent.this.endRandomAccess();
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        FileContentInputStream(InputStream instr) {
            super(instr);
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", DefaultFileContent.this.file, (Throwable)e);
            }
        }

        protected void onClose() throws IOException {
            DefaultFileContent.this.endInput(this);
        }
    }
}

