/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpClientFactory;

class FTPClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient = null;

    FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    private FTPClient createClient() throws FileSystemException {
        GenericFileName rootName = this.getRoot();
        return FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), rootName.getUserName(), rootName.getPassword(), rootName.getPath(), this.getFileSystemOptions());
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.getFtpClient().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String key, String relPath) throws IOException {
        try {
            return this.getFtpClient().listFiles(key, relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().listFiles(key, relPath);
        }
    }

    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    public boolean completePendingCommand() throws IOException {
        return this.getFtpClient().completePendingCommand();
    }

    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }
}

