/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.controller;

import at.twinformatics.eureka.adapter.consul.mapper.InstanceInfoMapper;
import at.twinformatics.eureka.adapter.consul.model.Service;
import at.twinformatics.eureka.adapter.consul.service.RegistrationService;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import rx.Single;

@Controller
public class ServiceController {
    private static final Logger log = LoggerFactory.getLogger(ServiceController.class);
    private static final String CONSUL_IDX_HEADER = "X-Consul-Index";
    private static final String QUERY_PARAM_WAIT = "wait";
    private static final String QUERY_PARAM_INDEX = "index";
    private static final Pattern WAIT_PATTERN = Pattern.compile("(\\d*)(m|s|ms|h)");
    private static final Random RANDOM = new Random();
    private final RegistrationService registrationService;
    private final InstanceInfoMapper instanceInfoMapper;

    @GetMapping(value={"/v1/catalog/services"}, produces={"application/json"})
    public Single<ResponseEntity<Map<String, String[]>>> getServiceNames(@QueryParam(value="wait") String wait, @QueryParam(value="index") Long index) {
        return this.registrationService.getServiceNames(this.getWaitMillis(wait), index).map(item -> this.createResponseEntity(item.getItem(), item.getChangeIndex()));
    }

    @GetMapping(value={"/v1/catalog/service/{appName}"}, produces={"application/json"})
    public Single<ResponseEntity<List<Service>>> getService(@PathVariable(value="appName") String appName, @QueryParam(value="wait") String wait, @QueryParam(value="index") Long index) {
        Assert.isTrue((appName != null ? 1 : 0) != 0, (String)"service name can not be null");
        return this.registrationService.getService(appName, this.getWaitMillis(wait), index).map(item -> {
            List services = ((List)item.getItem()).stream().map(this.instanceInfoMapper::map).collect(Collectors.toList());
            return this.createResponseEntity(services, item.getChangeIndex());
        });
    }

    private MultiValueMap<String, String> createHeaders(long index) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)CONSUL_IDX_HEADER, (Object)("" + index));
        return headers;
    }

    private <T> ResponseEntity<T> createResponseEntity(T body, long index) {
        return new ResponseEntity(body, this.createHeaders(index), HttpStatus.OK);
    }

    private long getWaitMillis(String wait) {
        long millis = TimeUnit.MINUTES.toMillis(5L);
        if (wait != null) {
            Matcher matcher = WAIT_PATTERN.matcher(wait);
            if (matcher.matches()) {
                Long value = Long.valueOf(matcher.group(1));
                TimeUnit timeUnit = this.parseTimeUnit(matcher.group(2));
                millis = timeUnit.toMillis(value);
            } else {
                throw new IllegalArgumentException("Invalid wait pattern");
            }
        }
        return millis + (long)RANDOM.nextInt((int)millis / 16 + 1);
    }

    private TimeUnit parseTimeUnit(String unit) {
        switch (unit) {
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new IllegalArgumentException("No valid time unit");
    }

    public ServiceController(RegistrationService registrationService, InstanceInfoMapper instanceInfoMapper) {
        this.registrationService = registrationService;
        this.instanceInfoMapper = instanceInfoMapper;
    }
}

