/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.service;

import at.twinformatics.eureka.adapter.consul.service.ServiceChangeDetector;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.resources.ServerCodecs;
import org.springframework.cloud.netflix.eureka.server.InstanceRegistry;
import org.springframework.stereotype.Component;

@Component
public class RegistrationEventInstanceRegistry
extends InstanceRegistry {
    private final ServiceChangeDetector serviceChangeDetector;

    public RegistrationEventInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient, int expectedNumberOfRenewsPerMin, int defaultOpenForTrafficCount, ServiceChangeDetector serviceChangeDetector) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient, expectedNumberOfRenewsPerMin, defaultOpenForTrafficCount);
        this.serviceChangeDetector = serviceChangeDetector;
    }

    public void register(InstanceInfo info, boolean isReplication) {
        super.register(info, isReplication);
        this.serviceChangeDetector.publish(info.getAppName(), System.currentTimeMillis());
    }

    public void register(InstanceInfo info, int leaseDuration, boolean isReplication) {
        super.register(info, leaseDuration, isReplication);
        this.serviceChangeDetector.publish(info.getAppName(), System.currentTimeMillis());
    }

    public boolean cancel(String appName, String serverId, boolean isReplication) {
        boolean wasCancelled = super.cancel(appName, serverId, isReplication);
        this.serviceChangeDetector.publish(appName, System.currentTimeMillis());
        return wasCancelled;
    }
}

