/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.service;

import at.twinformatics.eureka.adapter.consul.model.ChangeItem;
import at.twinformatics.eureka.adapter.consul.service.ServiceChangeDetector;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import rx.Observable;
import rx.Single;

@Component
public class RegistrationService {
    private static final Logger log = LoggerFactory.getLogger(RegistrationService.class);
    private static final BinaryOperator<String[]> MERGE_FUNCTION = (u, v) -> {
        throw new IllegalStateException("Duplicate key");
    };
    private static final String[] NO_SERVICE_TAGS = new String[0];
    private final PeerAwareInstanceRegistry registry;
    private final ServiceChangeDetector serviceChangeDetector;

    public Single<ChangeItem<Map<String, String[]>>> getServiceNames(long waitMillis, Long index) {
        return this.returnDeferred(waitMillis, index, this.serviceChangeDetector::getLastEmitted, this.serviceChangeDetector::getTotalIndex, () -> this.registry.getApplications().getRegisteredApplications().stream().collect(Collectors.toMap(Application::getName, a -> NO_SERVICE_TAGS, MERGE_FUNCTION, TreeMap::new)));
    }

    public Single<ChangeItem<List<InstanceInfo>>> getService(String appName, long waitMillis, Long index) {
        return this.returnDeferred(waitMillis, index, () -> this.serviceChangeDetector.getLastEmittedOfApp(appName), waitMillisInternal -> this.serviceChangeDetector.getIndexOfApp(appName, (long)waitMillisInternal), () -> {
            Application application = this.registry.getApplication(appName);
            if (application == null) {
                return Collections.emptyList();
            }
            return new ArrayList(application.getInstances());
        });
    }

    private <T> Single<ChangeItem<T>> returnDeferred(long waitMillis, Long index, Supplier<Long> lastEmitted, Function<Long, Observable<Long>> supplyObservable, Supplier<T> fn) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (index == null || !lastEmitted.get().equals(index)) {
            return Single.just(new ChangeItem<T>(fn.get(), lastEmitted.get()));
        }
        return supplyObservable.apply(waitMillis).map(idx -> new ChangeItem(fn.get(), (long)idx)).first().toSingle();
    }

    public RegistrationService(PeerAwareInstanceRegistry registry, ServiceChangeDetector serviceChangeDetector) {
        this.registry = registry;
        this.serviceChangeDetector = serviceChangeDetector;
    }
}

