/*
 * Decompiled with CFR 0.152.
 */
package at.twinformatics.eureka.adapter.consul.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import rx.Observable;
import rx.subjects.PublishSubject;

@Component
public class ServiceChangeDetector {
    private static final Logger log = LoggerFactory.getLogger(ServiceChangeDetector.class);
    private static final long INITIAL_VALUE = 1L;
    private final PublishSubject<ServiceChange> eventStream = PublishSubject.create();
    private final Map<String, AtomicLong> changeCounters = Collections.synchronizedMap(new HashMap());

    public void publish(String appName, long timestamp) {
        ServiceChange change = new ServiceChange(appName, timestamp);
        if (log.isDebugEnabled()) {
            log.debug("Incrementing change counter: appname {}, value {}", (Object)change.getName(), (Object)this.changeCounters.get(change.getName()));
        }
        this.changeCounters.computeIfAbsent(change.getName(), x -> new AtomicLong(1L)).set(change.getTimestamp());
        this.eventStream.onNext((Object)change);
    }

    public Observable<Long> getIndexOfApp(String appName, long millis) {
        return this.eventStream.filter(se -> se.getName().equals(appName)).timeout(millis, TimeUnit.MILLISECONDS).onErrorReturn(err -> this.mapTimeoutToServiceChange((Throwable)err, appName)).map(se -> this.getLastEmittedOfApp(se.getName()));
    }

    public Observable<Long> getTotalIndex(long millis) {
        return this.eventStream.timeout(millis, TimeUnit.MILLISECONDS).onErrorReturn(err -> this.mapTimeoutToServiceChange((Throwable)err, "")).map(se -> this.getLastEmitted());
    }

    public Long getLastEmitted() {
        Long lastEmitted = this.changeCounters.values().stream().mapToLong(AtomicLong::get).max().orElse(1L);
        if (log.isDebugEnabled()) {
            log.debug("Last emitted change counter of services {}", (Object)lastEmitted);
        }
        return lastEmitted;
    }

    public Long getLastEmittedOfApp(String appName) {
        long lastEmittedOfApp = this.changeCounters.getOrDefault(appName, new AtomicLong(1L)).longValue();
        if (log.isDebugEnabled()) {
            log.debug("Last emitted change counter of service {}: {}", (Object)appName, (Object)lastEmittedOfApp);
        }
        return lastEmittedOfApp;
    }

    public void reset() {
        this.changeCounters.clear();
    }

    private ServiceChange mapTimeoutToServiceChange(Throwable err, String appName) {
        if (err instanceof TimeoutException) {
            return new ServiceChange(appName, -1L);
        }
        throw new RuntimeException(err.getMessage(), err);
    }

    private static class ServiceChange {
        private String name;
        private long timestamp;

        public ServiceChange(String name, long timestamp) {
            this.name = name;
            this.timestamp = timestamp;
        }

        public String getName() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

