/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart;

import be.ceau.chart.Chart;
import be.ceau.chart.data.PieData;
import be.ceau.chart.dataset.PieDataset;
import be.ceau.chart.options.PieOptions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class PieChart
implements Chart {
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter().forType(PieChart.class);
    private final String type = "pie";
    private PieData data;
    private PieOptions options;

    public static PieData data() {
        return new PieData();
    }

    public static PieOptions options() {
        return new PieOptions();
    }

    public PieChart() {
    }

    public PieChart(PieData data) {
        this.data = data;
    }

    public PieChart(PieData data, PieOptions options) {
        this.data = data;
        this.options = options;
    }

    public PieData getData() {
        return this.data;
    }

    public PieChart setData(PieData data) {
        this.data = data;
        return this;
    }

    public PieOptions getOptions() {
        return this.options;
    }

    public PieChart setOptions(PieOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public String getType() {
        return "pie";
    }

    @Override
    public String toJson() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDrawable() {
        for (PieDataset dataset : this.data.getDatasets()) {
            if (dataset.getData().size() <= 1) continue;
            return true;
        }
        return false;
    }
}

