/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.spring.boot.autoconfigure.parse;

import ca.pjer.parseclient.Application;
import ca.pjer.parseclient.ParseClient;
import ca.pjer.parseclient.Perspective;
import ca.pjer.parseclient.support.SimpleConfigurations;
import ca.pjer.spring.boot.autoconfigure.parse.ParseProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@org.springframework.context.annotation.Configuration
@ConditionalOnProperty(prefix="parse", name={"serverUri"}, matchIfMissing=true)
@ComponentScan
public class ParseAutoConfiguration {
    @Autowired
    ParseProperties parseProperties;

    @Bean
    ObjectMapper parseClientJaxRsClientConfigurationObjectMapper() {
        return new ObjectMapper();
    }

    @Bean
    Configuration parseClientJaxRsClientConfiguration(@Autowired @Qualifier(value="parseClientJaxRsClientConfigurationObjectMapper") ObjectMapper objectMapper) {
        return SimpleConfigurations.jerseyWithJackson((ObjectMapper)objectMapper);
    }

    @Bean(destroyMethod="close")
    Client parseClientJaxRsClient(@Autowired @Qualifier(value="parseClientJaxRsClientConfiguration") Configuration configuration) {
        return ClientBuilder.newClient((Configuration)configuration);
    }

    @Bean
    ParseClient parseClient(@Autowired @Qualifier(value="parseClientJaxRsClient") Client client) {
        return ParseClient.create((Client)client, (URI)this.parseProperties.getServerUri());
    }

    @Bean
    @ConditionalOnProperty(prefix="parse", name={"applicationId"})
    Application application(@Autowired ParseClient parseClient) {
        Application application = parseClient.application(this.parseProperties.getApplicationId());
        if (this.parseProperties.getRestApiKey() != null) {
            application = application.usingRestApiKey(this.parseProperties.getRestApiKey());
        }
        if (this.parseProperties.getMasterKey() != null) {
            application = application.usingMasterKey(this.parseProperties.getMasterKey());
        }
        return application;
    }

    @Bean
    @ConditionalOnBean(value={Application.class})
    Perspective anonymousPerspective(@Autowired Application application) {
        return application.asAnonymous();
    }

    @Bean
    @ConditionalOnBean(value={Application.class})
    @ConditionalOnProperty(prefix="parse", name={"masterKey"})
    Perspective masterPerspective(@Autowired Application application) {
        return application.asMaster();
    }
}

