/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Options
implements PushModel {
    private static final String SENDNO = "sendno";
    private static final String OVERRIDE_MSG_ID = "override_msg_id";
    private static final String TIME_TO_LIVE = "time_to_live";
    private static final String APNS_PRODUCTION = "apns_production";
    private static final String BIG_PUSH_DURATION = "big_push_duration";
    private static final String APNS_COLLAPSE_ID = "apns_collapse_id";
    private static final String THIRD_PARTH_CHANNEl = "third_party_channel";
    private static final long NONE_TIME_TO_LIVE = -1L;
    private final int sendno;
    private final long overrideMsgId;
    private long timeToLive;
    private boolean apnsProduction;
    private int bigPushDuration;
    private String apnsCollapseId;
    private final Map<String, JsonPrimitive> customData;
    private Map<String, JsonObject> thirdPartyChannel;

    private Options(int sendno, long overrideMsgId, long timeToLive, boolean apnsProduction, int bigPushDuration, String apnsCollapseId, Map<String, JsonObject> thirdPartyChannel, Map<String, JsonPrimitive> customData) {
        this.sendno = sendno;
        this.overrideMsgId = overrideMsgId;
        this.timeToLive = timeToLive;
        this.apnsProduction = apnsProduction;
        this.bigPushDuration = bigPushDuration;
        this.apnsCollapseId = apnsCollapseId;
        this.thirdPartyChannel = thirdPartyChannel;
        this.customData = customData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Options sendno() {
        return Options.newBuilder().setSendno(ServiceHelper.generateSendno()).build();
    }

    public static Options sendno(int sendno) {
        return Options.newBuilder().setSendno(sendno).build();
    }

    public void setApnsProduction(boolean apnsProduction) {
        this.apnsProduction = apnsProduction;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setBigPushDuration(int bigPushDuration) {
        this.bigPushDuration = bigPushDuration;
    }

    public int getSendno() {
        return this.sendno;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (this.sendno > 0) {
            json.add(SENDNO, (JsonElement)new JsonPrimitive((Number)this.sendno));
        }
        if (this.overrideMsgId > 0L) {
            json.add(OVERRIDE_MSG_ID, (JsonElement)new JsonPrimitive((Number)this.overrideMsgId));
        }
        if (this.timeToLive >= 0L) {
            json.add(TIME_TO_LIVE, (JsonElement)new JsonPrimitive((Number)this.timeToLive));
        }
        json.add(APNS_PRODUCTION, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.apnsProduction)));
        if (this.bigPushDuration > 0) {
            json.add(BIG_PUSH_DURATION, (JsonElement)new JsonPrimitive((Number)this.bigPushDuration));
        }
        if (this.apnsCollapseId != null) {
            json.add(APNS_COLLAPSE_ID, (JsonElement)new JsonPrimitive(this.apnsCollapseId));
        }
        if (null != this.thirdPartyChannel && this.thirdPartyChannel.size() > 0) {
            JsonObject partyChannel = new JsonObject();
            for (Map.Entry<String, JsonObject> entry : this.thirdPartyChannel.entrySet()) {
                JsonObject channel = entry.getValue();
                partyChannel.add(entry.getKey(), (JsonElement)channel);
            }
            json.add(THIRD_PARTH_CHANNEl, (JsonElement)partyChannel);
        }
        if (null != this.customData) {
            for (Map.Entry<String, JsonPrimitive> entry : this.customData.entrySet()) {
                json.add(entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return json;
    }

    public static class Builder {
        private int sendno = 0;
        private long overrideMsgId = 0L;
        private long timeToLive = -1L;
        private boolean apnsProduction = false;
        private int bigPushDuration = 0;
        private String apnsCollapseId;
        private Map<String, JsonObject> thirdPartyChannel;
        private Map<String, JsonPrimitive> customData;

        public Builder setSendno(int sendno) {
            this.sendno = sendno;
            return this;
        }

        public Builder setOverrideMsgId(long overrideMsgId) {
            this.overrideMsgId = overrideMsgId;
            return this;
        }

        public Builder setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder setApnsProduction(boolean apnsProduction) {
            this.apnsProduction = apnsProduction;
            return this;
        }

        public Builder setApnsCollapseId(String id) {
            this.apnsCollapseId = id;
            return this;
        }

        public Builder setBigPushDuration(int bigPushDuration) {
            this.bigPushDuration = bigPushDuration;
            return this;
        }

        @Deprecated
        public Map<String, Map<String, String>> getThirdPartyChannel() {
            if (null != this.thirdPartyChannel) {
                HashMap<String, Map<String, String>> thirdPartyChannelRsp = new HashMap<String, Map<String, String>>();
                Set<Map.Entry<String, JsonObject>> entrySet = this.thirdPartyChannel.entrySet();
                for (Map.Entry<String, JsonObject> entry : entrySet) {
                    JsonObject entryValue = entry.getValue();
                    Set valueEntrySet = entryValue.entrySet();
                    HashMap valueMap = new HashMap();
                    for (Map.Entry valueEntry : valueEntrySet) {
                        valueMap.put(valueEntry.getKey(), null == valueEntry.getValue() ? null : ((JsonElement)valueEntry.getValue()).getAsString());
                    }
                    thirdPartyChannelRsp.put(entry.getKey(), valueMap);
                }
                return thirdPartyChannelRsp;
            }
            return null;
        }

        @Deprecated
        public Builder setThirdPartyChannel(Map<String, Map<String, String>> thirdPartyChannel) {
            this.thirdPartyChannel = new HashMap<String, JsonObject>();
            if (null != thirdPartyChannel) {
                Set<Map.Entry<String, Map<String, String>>> entrySet = thirdPartyChannel.entrySet();
                for (Map.Entry<String, Map<String, String>> entry : entrySet) {
                    String key = entry.getKey();
                    Map<String, String> valueMap = entry.getValue();
                    JsonObject valueObj = new JsonObject();
                    if (null == valueMap) continue;
                    Set<Map.Entry<String, String>> valueEntrySet = valueMap.entrySet();
                    for (Map.Entry<String, String> valueEntry : valueEntrySet) {
                        valueObj.addProperty(valueEntry.getKey(), valueEntry.getValue());
                    }
                    this.thirdPartyChannel.put(key, valueObj);
                }
            }
            return this;
        }

        public Builder setThirdPartyChannelV2(Map<String, JsonObject> thirdPartyChannel) {
            this.thirdPartyChannel = thirdPartyChannel;
            return this;
        }

        public Builder addCustom(Map<String, String> extras) {
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            for (Map.Entry<String, String> entry : extras.entrySet()) {
                this.customData.put(entry.getKey(), new JsonPrimitive(entry.getValue()));
            }
            return this;
        }

        public Builder addCustom(String key, Number value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Builder addCustom(String key, String value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Builder addCustom(String key, Boolean value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (this.customData == null) {
                this.customData = new LinkedHashMap<String, JsonPrimitive>();
            }
            this.customData.put(key, new JsonPrimitive(value));
            return this;
        }

        public Options build() {
            Preconditions.checkArgument((this.sendno >= 0 ? 1 : 0) != 0, (Object)"sendno should be greater than 0.");
            Preconditions.checkArgument((this.overrideMsgId >= 0L ? 1 : 0) != 0, (Object)"override_msg_id should be greater than 0.");
            Preconditions.checkArgument((this.timeToLive >= -1L ? 1 : 0) != 0, (Object)"time_to_live should be greater than 0.");
            Preconditions.checkArgument((this.bigPushDuration >= 0 ? 1 : 0) != 0, (Object)"bigPushDuration should be greater than 0.");
            if (this.sendno <= 0) {
                this.sendno = ServiceHelper.generateSendno();
            }
            return new Options(this.sendno, this.overrideMsgId, this.timeToLive, this.apnsProduction, this.bigPushDuration, this.apnsCollapseId, this.thirdPartyChannel, this.customData);
        }
    }
}

