/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DecayFunctionBase;
import co.elastic.clients.elasticsearch._types.query_dsl.DecayPlacement;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;

@JsonpDeserializable
public class DecayFunction
extends DecayFunctionBase
implements FunctionScoreVariant {
    private final String field;
    private final DecayPlacement placement;
    public static final JsonpDeserializer<DecayFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DecayFunction::setupDecayFunctionDeserializer);

    private DecayFunction(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.placement = ApiTypeHelper.requireNonNull(builder.placement, this, "placement");
    }

    public static DecayFunction of(Function<Builder, ObjectBuilder<DecayFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.Linear;
    }

    public final String field() {
        return this.field;
    }

    public final DecayPlacement placement() {
        return this.placement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.placement.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
    }

    protected static void setupDecayFunctionDeserializer(ObjectDeserializer<Builder> op) {
        DecayFunctionBase.setupDecayFunctionBaseDeserializer(op);
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.placement(DecayPlacement._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends DecayFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DecayFunction> {
        private String field;
        private DecayPlacement placement;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder placement(DecayPlacement value) {
            this.placement = value;
            return this;
        }

        public final Builder placement(Function<DecayPlacement.Builder, ObjectBuilder<DecayPlacement>> fn) {
            return this.placement(fn.apply(new DecayPlacement.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DecayFunction build() {
            this._checkSingleUse();
            return new DecayFunction(this);
        }
    }
}

