/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.TasksResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TasksRequest
extends CatRequestBase {
    private final List<String> actions;
    @Nullable
    private final Boolean detailed;
    private final List<String> nodeId;
    @Nullable
    private final Long parentTask;
    public static final Endpoint<TasksRequest, TasksResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TasksRequest, TasksResponse>("es/cat.tasks", request -> "GET", request -> "/_cat/tasks", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.detailed != null) {
            params.put("detailed", String.valueOf(request.detailed));
        }
        if (request.parentTask != null) {
            params.put("parent_task", String.valueOf(request.parentTask));
        }
        if (ApiTypeHelper.isDefined(request.actions)) {
            params.put("actions", request.actions.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.nodeId)) {
            params.put("node_id", request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, TasksResponse._DESERIALIZER);

    private TasksRequest(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiable(builder.actions);
        this.detailed = builder.detailed;
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.parentTask = builder.parentTask;
    }

    public static TasksRequest of(Function<Builder, ObjectBuilder<TasksRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> actions() {
        return this.actions;
    }

    @Nullable
    public final Boolean detailed() {
        return this.detailed;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Long parentTask() {
        return this.parentTask;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TasksRequest> {
        @Nullable
        private List<String> actions;
        @Nullable
        private Boolean detailed;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Long parentTask;

        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder detailed(@Nullable Boolean value) {
            this.detailed = value;
            return this;
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder parentTask(@Nullable Long value) {
            this.parentTask = value;
            return this;
        }

        @Override
        public TasksRequest build() {
            this._checkSingleUse();
            return new TasksRequest(this);
        }
    }
}

