/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.get_feature_upgrade_status;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MigrationFeatureIndexInfo
implements JsonpSerializable {
    private final String index;
    private final String version;
    @Nullable
    private final ErrorCause failureCause;
    public static final JsonpDeserializer<MigrationFeatureIndexInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrationFeatureIndexInfo::setupMigrationFeatureIndexInfoDeserializer);

    private MigrationFeatureIndexInfo(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.failureCause = builder.failureCause;
    }

    public static MigrationFeatureIndexInfo of(Function<Builder, ObjectBuilder<MigrationFeatureIndexInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final String version() {
        return this.version;
    }

    @Nullable
    public final ErrorCause failureCause() {
        return this.failureCause;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.failureCause != null) {
            generator.writeKey("failure_cause");
            this.failureCause.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMigrationFeatureIndexInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::failureCause, ErrorCause._DESERIALIZER, "failure_cause");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MigrationFeatureIndexInfo> {
        private String index;
        private String version;
        @Nullable
        private ErrorCause failureCause;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder failureCause(@Nullable ErrorCause value) {
            this.failureCause = value;
            return this;
        }

        public final Builder failureCause(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.failureCause(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MigrationFeatureIndexInfo build() {
            this._checkSingleUse();
            return new MigrationFeatureIndexInfo(this);
        }
    }
}

