/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Category;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetCategoriesResponse
implements JsonpSerializable {
    private final List<Category> categories;
    private final long count;
    public static final JsonpDeserializer<GetCategoriesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCategoriesResponse::setupGetCategoriesResponseDeserializer);

    private GetCategoriesResponse(Builder builder) {
        this.categories = ApiTypeHelper.unmodifiableRequired(builder.categories, (Object)this, "categories");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
    }

    public static GetCategoriesResponse of(Function<Builder, ObjectBuilder<GetCategoriesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public final long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.categories)) {
            generator.writeKey("categories");
            generator.writeStartArray();
            for (Category item0 : this.categories) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("count");
        generator.write(this.count);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetCategoriesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::categories, JsonpDeserializer.arrayDeserializer(Category._DESERIALIZER), "categories");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetCategoriesResponse> {
        private List<Category> categories;
        private Long count;

        public final Builder categories(List<Category> list) {
            this.categories = Builder._listAddAll(this.categories, list);
            return this;
        }

        public final Builder categories(Category value, Category ... values) {
            this.categories = Builder._listAdd(this.categories, value, values);
            return this;
        }

        public final Builder categories(Function<Category.Builder, ObjectBuilder<Category>> fn) {
            return this.categories(fn.apply(new Category.Builder()).build(), new Category[0]);
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCategoriesResponse build() {
            this._checkSingleUse();
            return new GetCategoriesResponse(this);
        }
    }
}

