/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceResponseResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class InferTrainedModelResponse
implements JsonpSerializable {
    private final List<InferenceResponseResult> inferenceResults;
    public static final JsonpDeserializer<InferTrainedModelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferTrainedModelResponse::setupInferTrainedModelResponseDeserializer);

    private InferTrainedModelResponse(Builder builder) {
        this.inferenceResults = ApiTypeHelper.unmodifiableRequired(builder.inferenceResults, (Object)this, "inferenceResults");
    }

    public static InferTrainedModelResponse of(Function<Builder, ObjectBuilder<InferTrainedModelResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<InferenceResponseResult> inferenceResults() {
        return this.inferenceResults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.inferenceResults)) {
            generator.writeKey("inference_results");
            generator.writeStartArray();
            for (InferenceResponseResult item0 : this.inferenceResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferTrainedModelResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inferenceResults, JsonpDeserializer.arrayDeserializer(InferenceResponseResult._DESERIALIZER), "inference_results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferTrainedModelResponse> {
        private List<InferenceResponseResult> inferenceResults;

        public final Builder inferenceResults(List<InferenceResponseResult> list) {
            this.inferenceResults = Builder._listAddAll(this.inferenceResults, list);
            return this;
        }

        public final Builder inferenceResults(InferenceResponseResult value, InferenceResponseResult ... values) {
            this.inferenceResults = Builder._listAdd(this.inferenceResults, value, values);
            return this;
        }

        public final Builder inferenceResults(Function<InferenceResponseResult.Builder, ObjectBuilder<InferenceResponseResult>> fn) {
            return this.inferenceResults(fn.apply(new InferenceResponseResult.Builder()).build(), new InferenceResponseResult[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferTrainedModelResponse build() {
            this._checkSingleUse();
            return new InferTrainedModelResponse(this);
        }
    }
}

