/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.watcher.Quantifier;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ArrayCompareOpParams
implements JsonpSerializable {
    private final Quantifier quantifier;
    private final FieldValue value;
    public static final JsonpDeserializer<ArrayCompareOpParams> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayCompareOpParams::setupArrayCompareOpParamsDeserializer);

    private ArrayCompareOpParams(Builder builder) {
        this.quantifier = ApiTypeHelper.requireNonNull(builder.quantifier, this, "quantifier");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static ArrayCompareOpParams of(Function<Builder, ObjectBuilder<ArrayCompareOpParams>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Quantifier quantifier() {
        return this.quantifier;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("quantifier");
        this.quantifier.serialize(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupArrayCompareOpParamsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::quantifier, Quantifier._DESERIALIZER, "quantifier");
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ArrayCompareOpParams> {
        private Quantifier quantifier;
        private FieldValue value;

        public final Builder quantifier(Quantifier value) {
            this.quantifier = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder value(String value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(long value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(double value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(boolean value) {
            this.value = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ArrayCompareOpParams build() {
            this._checkSingleUse();
            return new ArrayCompareOpParams(this);
        }
    }
}

