/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.TriggerEvent;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TriggerEventResult
implements JsonpSerializable {
    private final TriggerEvent manual;
    private final DateTime triggeredTime;
    private final String type;
    public static final JsonpDeserializer<TriggerEventResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TriggerEventResult::setupTriggerEventResultDeserializer);

    private TriggerEventResult(Builder builder) {
        this.manual = ApiTypeHelper.requireNonNull(builder.manual, this, "manual");
        this.triggeredTime = ApiTypeHelper.requireNonNull(builder.triggeredTime, this, "triggeredTime");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static TriggerEventResult of(Function<Builder, ObjectBuilder<TriggerEventResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final TriggerEvent manual() {
        return this.manual;
    }

    public final DateTime triggeredTime() {
        return this.triggeredTime;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("manual");
        this.manual.serialize(generator, mapper);
        generator.writeKey("triggered_time");
        this.triggeredTime.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTriggerEventResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::manual, TriggerEvent._DESERIALIZER, "manual");
        op.add(Builder::triggeredTime, DateTime._DESERIALIZER, "triggered_time");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TriggerEventResult> {
        private TriggerEvent manual;
        private DateTime triggeredTime;
        private String type;

        public final Builder manual(TriggerEvent value) {
            this.manual = value;
            return this;
        }

        public final Builder manual(Function<TriggerEvent.Builder, ObjectBuilder<TriggerEvent>> fn) {
            return this.manual(fn.apply(new TriggerEvent.Builder()).build());
        }

        public final Builder triggeredTime(DateTime value) {
            this.triggeredTime = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TriggerEventResult build() {
            this._checkSingleUse();
            return new TriggerEventResult(this);
        }
    }
}

