/*
 * Decompiled with CFR 0.152.
 */
package co.yml.charts.common.utils;

import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.text.TextStyle;
import co.yml.charts.common.model.LegendLabel;
import co.yml.charts.common.model.LegendsConfig;
import co.yml.charts.common.model.PlotType;
import co.yml.charts.common.model.Point;
import co.yml.charts.ui.barchart.models.BarData;
import co.yml.charts.ui.barchart.models.GroupBar;
import co.yml.charts.ui.piechart.models.PieChartData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000J\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0007J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u00f8\u0001\u0000J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lco/yml/charts/common/utils/DataUtils;", "", "()V", "getBarChartData", "", "Lco/yml/charts/ui/barchart/models/BarData;", "listSize", "", "maxRange", "getColorPaletteList", "Landroidx/compose/ui/graphics/Color;", "getDonutChartData", "Lco/yml/charts/ui/piechart/models/PieChartData;", "getGradientBarChartData", "getGroupBarChartData", "Lco/yml/charts/ui/barchart/models/GroupBar;", "barSize", "getLegendsConfigFromPieChartData", "Lco/yml/charts/common/model/LegendsConfig;", "pieChartData", "gridSize", "getLegendsLabelData", "Lco/yml/charts/common/model/LegendLabel;", "colorPaletteList", "getLineChartData", "Lco/yml/charts/common/model/Point;", "start", "getPieChartData", "getPieChartData2", "YChartsLib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUtils.kt\nco/yml/charts/common/utils/DataUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1855#2,2:230\n*S KotlinDebug\n*F\n+ 1 DataUtils.kt\nco/yml/charts/common/utils/DataUtils\n*L\n218#1:230,2\n*E\n"})
public final class DataUtils {
    @NotNull
    public static final DataUtils INSTANCE = new DataUtils();
    public static final int $stable;

    private DataUtils() {
    }

    @NotNull
    public final List<Point> getLineChartData(int listSize, int start, int maxRange) {
        ArrayList<Point> list = new ArrayList<Point>();
        for (int index = 0; index < listSize; ++index) {
            list.add(new Point(index, RangesKt.random((IntRange)RangesKt.until((int)start, (int)maxRange), (Random)((Random)Random.Default)), null, 4, null));
        }
        return list;
    }

    public static /* synthetic */ List getLineChartData$default(DataUtils dataUtils, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        return dataUtils.getLineChartData(n, n2, n3);
    }

    @NotNull
    public final List<BarData> getBarChartData(int listSize, int maxRange) {
        ArrayList<BarData> list = new ArrayList<BarData>();
        for (int index = 0; index < listSize; ++index) {
            float f = index;
            String string = "%.2f";
            Object[] objectArray = new Object[]{Random.Default.nextDouble(1.0, (double)maxRange)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            list.add(new BarData(new Point(f, Float.parseFloat(string2), null, 4, null), ColorKt.Color$default((int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)0, (int)8, null), "Bar" + index, null, null, 24, null));
        }
        return list;
    }

    @NotNull
    public final List<BarData> getGradientBarChartData(int listSize, int maxRange) {
        ArrayList<BarData> list = new ArrayList<BarData>();
        for (int index = 0; index < listSize; ++index) {
            float f = index;
            Object object = "%.2f";
            Object object2 = new Object[]{Random.Default.nextDouble(1.0, (double)maxRange)};
            String string = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
            Point point = new Point(f, Float.parseFloat(string), null, 4, null);
            object2 = new Color[]{Color.box-impl((long)ColorKt.Color$default((int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)0, (int)8, null)), Color.box-impl((long)ColorKt.Color$default((int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)0, (int)8, null)), Color.box-impl((long)ColorKt.Color$default((int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)0, (int)8, null)), Color.box-impl((long)ColorKt.Color$default((int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)Random.Default.nextInt(256), (int)0, (int)8, null))};
            object = CollectionsKt.listOf((Object[])object2);
            object2 = "Bar" + index;
            list.add(new BarData(point, 0L, (String)object2, (List)object, null, 18, null));
        }
        return list;
    }

    @NotNull
    public final PieChartData getPieChartData() {
        Object[] objectArray = new PieChartData.Slice[]{new PieChartData.Slice("SciFi", 15.0f, ColorKt.Color((long)0xFF333333L), null, 8, null), new PieChartData.Slice("Comedy", 15.0f, ColorKt.Color((long)4284902022L), null, 8, null), new PieChartData.Slice("Drama", 10.0f, ColorKt.Color((long)4288002257L), null, 8, null), new PieChartData.Slice("Romance", 10.0f, ColorKt.Color((long)4293451189L), null, 8, null), new PieChartData.Slice("Action", 20.0f, ColorKt.Color((long)4293767096L), null, 8, null), new PieChartData.Slice("Thriller", 100.0f, ColorKt.Color((long)4294527122L), null, 8, null), new PieChartData.Slice("Western", 10.0f, ColorKt.Color((long)4289099169L), null, 8, null), new PieChartData.Slice("Fantasy", 10.0f, ColorKt.Color((long)4287576453L), null, 8, null)};
        return new PieChartData(CollectionsKt.listOf((Object[])objectArray), PlotType.Pie.INSTANCE);
    }

    @NotNull
    public final PieChartData getPieChartData2() {
        Object[] objectArray = new PieChartData.Slice[]{new PieChartData.Slice("Android", 30.0f, ColorKt.Color((long)4278201179L), null, 8, null), new PieChartData.Slice("iOS", 30.0f, ColorKt.Color((long)4281026661L), null, 8, null), new PieChartData.Slice("Windows", 15.0f, ColorKt.Color((long)4280642949L), null, 8, null), new PieChartData.Slice("Other", 25.0f, ColorKt.Color((long)4286606725L), null, 8, null)};
        return new PieChartData(CollectionsKt.listOf((Object[])objectArray), PlotType.Pie.INSTANCE);
    }

    @NotNull
    public final PieChartData getDonutChartData() {
        Object[] objectArray = new PieChartData.Slice[]{new PieChartData.Slice("HP", 15.0f, ColorKt.Color((long)4284418695L), null, 8, null), new PieChartData.Slice("Dell", 30.0f, ColorKt.Color((long)4280336213L), null, 8, null), new PieChartData.Slice("Lenovo", 10.0f, ColorKt.Color((long)4288939526L), null, 8, null), new PieChartData.Slice("Asus", 15.0f, ColorKt.Color((long)4294260804L), null, 8, null), new PieChartData.Slice("Acer", 10.0f, ColorKt.Color((long)4293697285L), null, 8, null), new PieChartData.Slice("Apple", 30.0f, ColorKt.Color((long)4278231037L), null, 8, null)};
        return new PieChartData(CollectionsKt.listOf((Object[])objectArray), PlotType.Donut.INSTANCE);
    }

    @NotNull
    public final List<GroupBar> getGroupBarChartData(int listSize, int maxRange, int barSize) {
        List list = new ArrayList();
        for (int index = 0; index < listSize; ++index) {
            List barList = new ArrayList();
            for (int i = 0; i < barSize; ++i) {
                String string = "%.2f";
                Object object = new Object[]{Random.Default.nextDouble(1.0, (double)maxRange)};
                String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                float barValue = Float.parseFloat(string2);
                Point point = new Point(i, barValue, null, 4, null);
                String string3 = "" + 'B' + i;
                StringBuilder stringBuilder = new StringBuilder().append("Bar at ").append(i).append(" with label B").append(i).append(" has value ");
                object = "%.2f";
                Object[] objectArray = new Object[]{Float.valueOf(barValue)};
                String string4 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                barList.add(new BarData(point, 0L, string3, null, stringBuilder.append(string4).toString(), 10, null));
            }
            list.add(new GroupBar(String.valueOf(index), barList));
        }
        return list;
    }

    @NotNull
    public final List<LegendLabel> getLegendsLabelData(@NotNull List<Color> colorPaletteList) {
        Intrinsics.checkNotNullParameter(colorPaletteList, (String)"colorPaletteList");
        List legendLabelList = new ArrayList();
        int n = colorPaletteList.size();
        for (int index = 0; index < n; ++index) {
            legendLabelList.add(new LegendLabel(colorPaletteList.get(index).unbox-impl(), "" + 'B' + index, null));
        }
        return legendLabelList;
    }

    @NotNull
    public final List<Color> getColorPaletteList(int listSize) {
        List colorList = new ArrayList();
        for (int index = 0; index < listSize; ++index) {
            colorList.add(Color.box-impl((long)ColorKt.Color$default((int)RangesKt.random((IntRange)RangesKt.until((int)0, (int)256), (Random)((Random)Random.Default)), (int)RangesKt.random((IntRange)RangesKt.until((int)0, (int)256), (Random)((Random)Random.Default)), (int)RangesKt.random((IntRange)RangesKt.until((int)0, (int)256), (Random)((Random)Random.Default)), (int)0, (int)8, null)));
        }
        return colorList;
    }

    @NotNull
    public final LegendsConfig getLegendsConfigFromPieChartData(@NotNull PieChartData pieChartData, int gridSize) {
        Intrinsics.checkNotNullParameter((Object)pieChartData, (String)"pieChartData");
        List legendsList = new ArrayList();
        Iterable $this$forEach$iv = pieChartData.getSlices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PieChartData.Slice slice = (PieChartData.Slice)element$iv;
            boolean bl = false;
            legendsList.add(new LegendLabel(slice.getColor-0d7_KjU(), slice.getLabel(), null));
        }
        Arrangement.Horizontal horizontal = Arrangement.INSTANCE.getStart();
        TextStyle textStyle = new TextStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 0L, null, null, null, null, null, 0x3FFFFF, null);
        return new LegendsConfig(legendsList, gridSize, 0.0f, 0.0f, 0.0f, textStyle, 0.0f, horizontal, 92, null);
    }
}

