/*
 * Decompiled with CFR 0.152.
 */
package co.yml.charts.ui.piechart.models;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import co.yml.charts.common.model.PlotData;
import co.yml.charts.common.model.PlotType;
import co.yml.charts.ui.piechart.utils.PieChartUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lco/yml/charts/ui/piechart/models/PieChartData;", "Lco/yml/charts/common/model/PlotData;", "slices", "", "Lco/yml/charts/ui/piechart/models/PieChartData$Slice;", "plotType", "Lco/yml/charts/common/model/PlotType;", "(Ljava/util/List;Lco/yml/charts/common/model/PlotType;)V", "getPlotType", "()Lco/yml/charts/common/model/PlotType;", "getSlices", "()Ljava/util/List;", "totalLength", "", "getTotalLength", "()F", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Slice", "YChartsLib_release"})
@StabilityInferred(parameters=0)
public final class PieChartData
implements PlotData {
    @NotNull
    private final List<Slice> slices;
    @NotNull
    private final PlotType plotType;
    public static final int $stable = 8;

    public PieChartData(@NotNull List<Slice> slices, @NotNull PlotType plotType) {
        Intrinsics.checkNotNullParameter(slices, (String)"slices");
        Intrinsics.checkNotNullParameter((Object)plotType, (String)"plotType");
        this.slices = slices;
        this.plotType = plotType;
    }

    @NotNull
    public final List<Slice> getSlices() {
        return this.slices;
    }

    @Override
    @NotNull
    public PlotType getPlotType() {
        return this.plotType;
    }

    public final float getTotalLength() {
        return PieChartUtilsKt.sum(this.slices);
    }

    @NotNull
    public final List<Slice> component1() {
        return this.slices;
    }

    @NotNull
    public final PlotType component2() {
        return this.getPlotType();
    }

    @NotNull
    public final PieChartData copy(@NotNull List<Slice> slices, @NotNull PlotType plotType) {
        Intrinsics.checkNotNullParameter(slices, (String)"slices");
        Intrinsics.checkNotNullParameter((Object)plotType, (String)"plotType");
        return new PieChartData(slices, plotType);
    }

    public static /* synthetic */ PieChartData copy$default(PieChartData pieChartData, List list, PlotType plotType, int n, Object object) {
        if ((n & 1) != 0) {
            list = pieChartData.slices;
        }
        if ((n & 2) != 0) {
            plotType = pieChartData.getPlotType();
        }
        return pieChartData.copy(list, plotType);
    }

    @NotNull
    public String toString() {
        return "PieChartData(slices=" + this.slices + ", plotType=" + this.getPlotType() + ')';
    }

    public int hashCode() {
        int result = ((Object)this.slices).hashCode();
        result = result * 31 + this.getPlotType().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PieChartData)) {
            return false;
        }
        PieChartData pieChartData = (PieChartData)other;
        if (!Intrinsics.areEqual(this.slices, pieChartData.slices)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getPlotType(), (Object)pieChartData.getPlotType());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0019\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\rJ\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003JJ\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\nH\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lco/yml/charts/ui/piechart/models/PieChartData$Slice;", "", "label", "", "value", "", "color", "Landroidx/compose/ui/graphics/Color;", "sliceDescription", "Lkotlin/Function1;", "", "(Ljava/lang/String;FJLkotlin/jvm/functions/Function1;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getColor-0d7_KjU", "()J", "J", "getLabel", "()Ljava/lang/String;", "getSliceDescription", "()Lkotlin/jvm/functions/Function1;", "getValue", "()F", "component1", "component2", "component3", "component3-0d7_KjU", "component4", "copy", "copy-9LQNqLg", "(Ljava/lang/String;FJLkotlin/jvm/functions/Function1;)Lco/yml/charts/ui/piechart/models/PieChartData$Slice;", "equals", "", "other", "hashCode", "toString", "YChartsLib_release"})
    @StabilityInferred(parameters=0)
    public static final class Slice {
        @NotNull
        private final String label;
        private final float value;
        private final long color;
        @NotNull
        private final Function1<Integer, String> sliceDescription;
        public static final int $stable;

        private Slice(String label, float value, long color, Function1<? super Integer, String> sliceDescription) {
            this.label = label;
            this.value = value;
            this.color = color;
            this.sliceDescription = sliceDescription;
        }

        public /* synthetic */ Slice(final String string, float f, long l, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function1 = (Function1)new Function1<Integer, String>(){

                    @NotNull
                    public final String invoke(int slicePercentage) {
                        return "Slice name : " + string + "  \nPercentage  : " + slicePercentage + " %";
                    }
                };
            }
            this(string, f, l, function1, null);
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final float getValue() {
            return this.value;
        }

        public final long getColor-0d7_KjU() {
            return this.color;
        }

        @NotNull
        public final Function1<Integer, String> getSliceDescription() {
            return this.sliceDescription;
        }

        @NotNull
        public final String component1() {
            return this.label;
        }

        public final float component2() {
            return this.value;
        }

        public final long component3-0d7_KjU() {
            return this.color;
        }

        @NotNull
        public final Function1<Integer, String> component4() {
            return this.sliceDescription;
        }

        @NotNull
        public final Slice copy-9LQNqLg(@NotNull String label, float value, long color, @NotNull Function1<? super Integer, String> sliceDescription) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(sliceDescription, (String)"sliceDescription");
            return new Slice(label, value, color, sliceDescription, null);
        }

        public static /* synthetic */ Slice copy-9LQNqLg$default(Slice slice, String string, float f, long l, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = slice.label;
            }
            if ((n & 2) != 0) {
                f = slice.value;
            }
            if ((n & 4) != 0) {
                l = slice.color;
            }
            if ((n & 8) != 0) {
                function1 = slice.sliceDescription;
            }
            return slice.copy-9LQNqLg(string, f, l, function1);
        }

        @NotNull
        public String toString() {
            return "Slice(label=" + this.label + ", value=" + this.value + ", color=" + Color.toString-impl((long)this.color) + ", sliceDescription=" + this.sliceDescription + ')';
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = result * 31 + Float.hashCode(this.value);
            result = result * 31 + Color.hashCode-impl((long)this.color);
            result = result * 31 + this.sliceDescription.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Slice)) {
                return false;
            }
            Slice slice = (Slice)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)slice.label)) {
                return false;
            }
            if (Float.compare(this.value, slice.value) != 0) {
                return false;
            }
            if (!Color.equals-impl0((long)this.color, (long)slice.color)) {
                return false;
            }
            return Intrinsics.areEqual(this.sliceDescription, slice.sliceDescription);
        }

        public /* synthetic */ Slice(String label, float value, long color, Function1 sliceDescription, DefaultConstructorMarker $constructor_marker) {
            this(label, value, color, (Function1<? super Integer, String>)sliceDescription);
        }
    }
}

