/*
 * Decompiled with CFR 0.152.
 */
package com.adarshr.gradle.testlogger.logger;

import com.adarshr.gradle.testlogger.TestLoggerExtension;
import com.adarshr.gradle.testlogger.logger.ParallelTestLogger;
import com.adarshr.gradle.testlogger.logger.SequentialTestLogger;
import com.adarshr.gradle.testlogger.logger.TestLogger;
import com.adarshr.gradle.testlogger.theme.Theme;
import com.adarshr.gradle.testlogger.theme.ThemeFactory;
import com.adarshr.gradle.testlogger.theme.ThemeType;
import groovy.lang.Delegate;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.testng.TestNGOptions;

public class TestLoggerWrapper
implements TestLogger,
GroovyObject {
    @Delegate
    private final TestLogger testLoggerDelegate;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public TestLoggerWrapper(Project project, Test test, TestLoggerExtension testLoggerExtension) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Theme theme = ThemeFactory.getTheme(testLoggerExtension);
        TestLoggerWrapper.ensureCorrectThemeType(test, theme);
        if (theme.getType().isParallel()) {
            ParallelTestLogger parallelTestLogger = new ParallelTestLogger(project, testLoggerExtension);
            this.testLoggerDelegate = parallelTestLogger;
        } else {
            SequentialTestLogger sequentialTestLogger = new SequentialTestLogger(project, testLoggerExtension);
            this.testLoggerDelegate = sequentialTestLogger;
        }
    }

    private static void ensureCorrectThemeType(Test test, Theme theme) {
        boolean testNgParallelMode = test.getOptions() instanceof TestNGOptions && DefaultTypeTransformation.booleanUnbox((Object)((TestNGOptions)ScriptBytecodeAdapter.asType((Object)test.getOptions(), TestNGOptions.class)).getParallel());
        if ((test.getMaxParallelForks() > 1 || testNgParallelMode) && !theme.getType().isParallel()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{theme.getType().getName()}, new String[]{"Parallel execution is not supported for theme type '", "'. "}).plus((GString)new GStringImpl(new Object[]{ThemeType.getParallelThemeNames()}, new String[]{"Must be one of ", ""}))));
        }
    }

    @Generated
    public void beforeSuite(TestDescriptor param0) {
        this.testLoggerDelegate.beforeSuite(param0);
    }

    @Generated
    public void afterSuite(TestDescriptor param0, TestResult param1) {
        this.testLoggerDelegate.afterSuite(param0, param1);
    }

    @Generated
    public void beforeTest(TestDescriptor param0) {
        this.testLoggerDelegate.beforeTest(param0);
    }

    @Generated
    public void afterTest(TestDescriptor param0, TestResult param1) {
        this.testLoggerDelegate.afterTest(param0, param1);
    }

    @Generated
    public void onOutput(TestDescriptor param0, TestOutputEvent param1) {
        this.testLoggerDelegate.onOutput(param0, param1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestLoggerWrapper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

